/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnInputStream;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnOutputStream;
import java.io.IOException;
import java.util.Vector;

public final class AsnSequence
extends AsnObject {
    private final AsnObject[] vals;

    AsnSequence(AsnInputStream is) throws IOException {
        super((byte)48);
        int len = is.readLength();
        AsnInputStream sub_is = is.getSubStream(len);
        Vector<AsnObject> vec = new Vector<AsnObject>(3);
        while (sub_is.available() > 0) {
            vec.addElement(sub_is.read());
        }
        this.vals = new AsnObject[vec.size()];
        vec.copyInto(this.vals);
    }

    public AsnSequence(AsnObject a, AsnObject b) {
        super((byte)48);
        AsnObject[] objs = new AsnObject[]{a, b};
        this.vals = objs;
    }

    public AsnSequence(AsnObject[] vals) {
        super((byte)48);
        this.vals = (AsnObject[])vals.clone();
    }

    protected void encodePayload(AsnOutputStream os) throws IOException {
        int i = 0;
        while (i < this.vals.length) {
            os.write(this.vals[i]);
            ++i;
        }
    }

    public AsnObject get(int index) {
        return this.vals[index];
    }

    protected int getEncodedLengthOfPayload(AsnOutputStream os) {
        int len = 0;
        int i = 0;
        while (i < this.vals.length) {
            len += this.vals[i].getEncodedLength(os);
            ++i;
        }
        return len;
    }

    public int size() {
        return this.vals.length;
    }

    public String toString(String indent) {
        String s = String.valueOf(indent) + "SEQUENCE (" + this.vals.length + " elements):";
        int i = 0;
        while (i < this.vals.length) {
            s = String.valueOf(s) + "\n" + this.vals[i].toString(String.valueOf(indent) + "    ");
            ++i;
        }
        return s;
    }
}

