/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson1.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Namespace;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.modules.jackson1.EnunciateJackson1Context;
import com.webcohesion.enunciate.modules.jackson1.api.impl.CustomExampleImpl;
import com.webcohesion.enunciate.modules.jackson1.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jackson1.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jackson1.api.impl.EnumDataTypeImpl;
import com.webcohesion.enunciate.modules.jackson1.api.impl.MediaTypeDescriptorImpl;
import com.webcohesion.enunciate.modules.jackson1.api.impl.ObjectDataTypeImpl;
import com.webcohesion.enunciate.modules.jackson1.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson1.model.types.JsonTypeFactory;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class SyntaxImpl
implements Syntax,
Namespace {
    public static final String SYNTAX_LABEL = "JSON";
    private final EnunciateJackson1Context context;
    private ApiRegistrationContext registrationContext;

    public SyntaxImpl(EnunciateJackson1Context context, ApiRegistrationContext registrationContext) {
        this.context = context;
        this.registrationContext = registrationContext;
    }

    public String getId() {
        return "jackson1";
    }

    public int compareTo(Syntax syntax) {
        return this.getId().compareTo(syntax.getId());
    }

    public String getSlug() {
        return "syntax_json";
    }

    public String getLabel() {
        return SYNTAX_LABEL;
    }

    public boolean isEmpty() {
        return this.context.getTypeDefinitions().isEmpty();
    }

    public List<Namespace> getNamespaces() {
        return Collections.singletonList(this);
    }

    public boolean isAssignableToMediaType(String mediaType) {
        return mediaType != null && (mediaType.equals("*/*") || mediaType.equals("application/*") || mediaType.endsWith("/json") || mediaType.endsWith("+json"));
    }

    public MediaTypeDescriptor findMediaTypeDescriptor(String mediaType, DecoratedTypeMirror typeMirror) {
        if (mediaType == null) {
            return null;
        }
        if (mediaType.equals("*/*") || mediaType.equals("application/*")) {
            mediaType = "application/json";
        }
        if (mediaType.endsWith("/json") || mediaType.endsWith("+json")) {
            DataTypeReference typeReference = this.findDataTypeReference(typeMirror = this.context.resolveSyntheticType(typeMirror));
            return typeReference == null ? null : new MediaTypeDescriptorImpl(mediaType, typeReference);
        }
        return null;
    }

    private DataTypeReference findDataTypeReference(DecoratedTypeMirror typeMirror) {
        JsonType jsonType;
        if (typeMirror == null) {
            return null;
        }
        try {
            jsonType = JsonTypeFactory.getJsonType((TypeMirror)typeMirror, this.context);
        }
        catch (Exception e) {
            jsonType = null;
        }
        return jsonType == null ? null : new DataTypeReferenceImpl(jsonType, this.registrationContext);
    }

    public List<DataType> findDataTypes(String name) {
        TypeElement typeElement;
        if (name != null && !name.isEmpty() && (typeElement = this.context.getContext().getProcessingEnvironment().getElementUtils().getTypeElement(name)) != null) {
            TypeDefinition typeDefinition = this.context.findTypeDefinition(typeElement);
            if (typeDefinition instanceof ObjectTypeDefinition) {
                return Collections.singletonList(new ObjectDataTypeImpl((ObjectTypeDefinition)typeDefinition, this.registrationContext));
            }
            if (typeDefinition instanceof EnumTypeDefinition) {
                return Collections.singletonList(new EnumDataTypeImpl((EnumTypeDefinition)typeDefinition, this.registrationContext));
            }
        }
        return Collections.emptyList();
    }

    public Example parseExample(Reader example) throws Exception {
        ObjectMapper mapper = new ObjectMapper().enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
        return new CustomExampleImpl(mapper.writeValueAsString((Object)mapper.readTree(example)));
    }

    public String getUri() {
        return null;
    }

    public InterfaceDescriptionFile getSchemaFile() {
        return null;
    }

    public List<? extends DataType> getTypes() {
        Collection<TypeDefinition> typeDefinitions = this.context.getTypeDefinitions();
        ArrayList<DataTypeImpl> dataTypes = new ArrayList<DataTypeImpl>();
        FacetFilter facetFilter = this.registrationContext.getFacetFilter();
        for (TypeDefinition typeDefinition : typeDefinitions) {
            if (!facetFilter.accept((HasFacets)typeDefinition)) continue;
            if (typeDefinition instanceof ObjectTypeDefinition) {
                dataTypes.add(new ObjectDataTypeImpl((ObjectTypeDefinition)typeDefinition, this.registrationContext));
                continue;
            }
            if (!(typeDefinition instanceof EnumTypeDefinition)) continue;
            dataTypes.add(new EnumDataTypeImpl((EnumTypeDefinition)typeDefinition, this.registrationContext));
        }
        Collections.sort(dataTypes, new Comparator<DataType>(){

            @Override
            public int compare(DataType o1, DataType o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        return dataTypes;
    }
}

