/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.internal.TableParagraphPreProcessor;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.internal.MarkdownWriter;
import com.vladsch.flexmark.formatter.internal.NodeFormatter;
import com.vladsch.flexmark.formatter.internal.NodeFormatterContext;
import com.vladsch.flexmark.formatter.internal.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.internal.NodeFormattingHandler;
import com.vladsch.flexmark.util.format.Table;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.html.FormattingAppendable;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TableNodeFormatter
implements NodeFormatter {
    private final TableFormatOptions options;
    private Table myTable;

    public TableNodeFormatter(DataHolder options) {
        this.options = new TableFormatOptions(options);
    }

    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(TableBlock.class, (CustomNodeFormatter)new CustomNodeFormatter<TableBlock>(){

            public void render(TableBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableHead.class, (CustomNodeFormatter)new CustomNodeFormatter<TableHead>(){

            public void render(TableHead node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableSeparator.class, (CustomNodeFormatter)new CustomNodeFormatter<TableSeparator>(){

            public void render(TableSeparator node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableBody.class, (CustomNodeFormatter)new CustomNodeFormatter<TableBody>(){

            public void render(TableBody node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableRow.class, (CustomNodeFormatter)new CustomNodeFormatter<TableRow>(){

            public void render(TableRow node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableCell.class, (CustomNodeFormatter)new CustomNodeFormatter<TableCell>(){

            public void render(TableCell node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableCaption.class, (CustomNodeFormatter)new CustomNodeFormatter<TableCaption>(){

            public void render(TableCaption node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(Text.class, (CustomNodeFormatter)new CustomNodeFormatter<Text>(){

            public void render(Text node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    private void render(TableBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable = new Table(this.options);
        context.renderChildren((Node)node);
        this.myTable.finalizeTable();
        if (this.myTable.getMaxColumns() > 0) {
            markdown.blankLine();
            this.myTable.appendTable((FormattingAppendable)markdown);
            markdown.blankLine();
        }
    }

    private void render(TableHead node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(false);
        this.myTable.setHeading(true);
        context.renderChildren((Node)node);
    }

    private void render(TableSeparator node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(true);
        context.renderChildren((Node)node);
    }

    private void render(TableBody node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(false);
        this.myTable.setHeading(false);
        context.renderChildren((Node)node);
    }

    private void render(TableRow node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.renderChildren((Node)node);
        if (!this.myTable.isSeparator()) {
            this.myTable.nextRow();
        }
    }

    private void render(TableCaption node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setCaption((CharSequence)node.getOpeningMarker(), (CharSequence)node.getText(), (CharSequence)node.getClosingMarker());
    }

    private void render(TableCell node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.addCell(new Table.TableCell((CharSequence)node.getOpeningMarker(), (CharSequence)node.getText(), (CharSequence)node.getClosingMarker(), 1, node.getSpan(), node.getAlignment() == null ? CellAlignment.NONE : node.getAlignment().cellAlignment()));
    }

    private void render(Text node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (TableParagraphPreProcessor.TABLE_HEADER_SEPARATOR.matcher((CharSequence)node.getChars()).matches()) {
            Node parent = node.getAncestorOfType(new Class[]{Paragraph.class});
            if (parent instanceof Paragraph && ((Paragraph)parent).hasTableSeparator()) {
                markdown.pushPrefix().addPrefix((CharSequence)" ").append((CharSequence)node.getChars()).popPrefix();
            } else {
                markdown.append((CharSequence)node.getChars());
            }
        } else {
            markdown.append((CharSequence)node.getChars());
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        public NodeFormatter create(DataHolder options) {
            return new TableNodeFormatter(options);
        }
    }
}

