/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedOrdinalRenderer;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRendering;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferences;
import com.vladsch.flexmark.util.ast.DoNotCollectText;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;

public class EnumRefTextCollectingVisitor {
    private SequenceBuilder out;
    private final NodeVisitor visitor;
    private Runnable ordinalRunnable;

    public EnumRefTextCollectingVisitor() {
        this(-1);
    }

    public EnumRefTextCollectingVisitor(int ordinal) {
        this.ordinalRunnable = ordinal < 0 ? null : () -> {
            SequenceBuilder cfr_ignored_0 = (SequenceBuilder)this.out.add((CharSequence)String.valueOf(ordinal));
        };
        this.visitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Text.class, this::visit), new VisitHandler(TextBase.class, this::visit), new VisitHandler(HtmlEntity.class, this::visit), new VisitHandler(SoftLineBreak.class, this::visit), new VisitHandler(HardLineBreak.class, this::visit), new VisitHandler(EnumeratedReferenceText.class, this::visit), new VisitHandler(EnumeratedReferenceLink.class, this::visit)});
    }

    public String getText() {
        return this.out.toString();
    }

    public void collect(BasedSequence basedSequence, EnumeratedReferenceRendering[] renderings, String defaultFormat) {
        this.out = SequenceBuilder.emptyBuilder((BasedSequence)basedSequence);
        EnumeratedReferences.renderReferenceOrdinals(renderings, new OrdinalRenderer(this));
    }

    public String collectAndGetText(BasedSequence basedSequence, EnumeratedReferenceRendering[] renderings, String defaultFormat) {
        this.collect(basedSequence, renderings, defaultFormat);
        return this.out.toString();
    }

    private void visit(EnumeratedReferenceText node) {
        String text = node.getText().toString();
        if (text.isEmpty() && this.ordinalRunnable != null) {
            this.ordinalRunnable.run();
        }
    }

    private void visit(EnumeratedReferenceLink node) {
        String text = node.getText().toString();
        if (text.isEmpty() && this.ordinalRunnable != null) {
            this.ordinalRunnable.run();
        }
    }

    private void visit(SoftLineBreak node) {
        this.out.add((CharSequence)node.getChars());
    }

    private void visit(HardLineBreak node) {
        BasedSequence chars = node.getChars();
        this.out.add((CharSequence)chars.subSequence(chars.length() - 1, chars.length()));
    }

    private void visit(HtmlEntity node) {
        this.out.add((CharSequence)node.getChars().unescape());
    }

    private void visit(Text node) {
        if (!node.isOrDescendantOfType(new Class[]{DoNotCollectText.class})) {
            this.out.add((CharSequence)node.getChars());
        }
    }

    private void visit(TextBase node) {
        this.out.add((CharSequence)node.getChars());
    }

    private static class OrdinalRenderer
    implements EnumeratedOrdinalRenderer {
        final EnumRefTextCollectingVisitor renderer;

        public OrdinalRenderer(EnumRefTextCollectingVisitor renderer) {
            this.renderer = renderer;
        }

        @Override
        public void startRendering(EnumeratedReferenceRendering[] renderings) {
        }

        @Override
        public void setEnumOrdinalRunnable(Runnable runnable) {
            this.renderer.ordinalRunnable = runnable;
        }

        @Override
        public Runnable getEnumOrdinalRunnable() {
            return this.renderer.ordinalRunnable;
        }

        @Override
        public void render(int referenceOrdinal, EnumeratedReferenceBlock referenceFormat, String defaultText, boolean needSeparator) {
            Runnable compoundRunnable = this.renderer.ordinalRunnable;
            if (referenceFormat != null) {
                this.renderer.ordinalRunnable = () -> {
                    if (compoundRunnable != null) {
                        compoundRunnable.run();
                    }
                    this.renderer.out.add((CharSequence)String.valueOf(referenceOrdinal));
                    if (needSeparator) {
                        this.renderer.out.add((CharSequence)".");
                    }
                };
                this.renderer.visitor.visitChildren((Node)referenceFormat);
            } else {
                this.renderer.out.add((CharSequence)(defaultText + " "));
                if (compoundRunnable != null) {
                    compoundRunnable.run();
                }
                this.renderer.out.add((CharSequence)String.valueOf(referenceOrdinal));
                if (needSeparator) {
                    this.renderer.out.add((CharSequence)".");
                }
            }
        }

        @Override
        public void endRendering() {
        }
    }
}

