/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.viteproxy;

import com.vaadin.base.devserver.ViteHandler;
import com.vaadin.base.devserver.viteproxy.ViteWebsocketProxy;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import jakarta.servlet.ServletContext;
import jakarta.websocket.CloseReason;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViteWebsocketEndpoint
extends Endpoint {
    public static final String VITE_HANDLER = "viteServer";
    private static final Map<String, ViteWebsocketProxy> proxies = Collections.synchronizedMap(new HashMap());

    public static void init(VaadinContext context, ViteHandler viteHandler) {
        ServletContext servletContext = ((VaadinServletContext)context).getContext();
        ServerContainer container = (ServerContainer)servletContext.getAttribute(ServerContainer.class.getName());
        if (container == null) {
            ViteWebsocketEndpoint.getLogger().error("Unable to deploy Vite websocket endpoint, no container value is available");
            return;
        }
        try {
            List<String> subProtocols = Collections.singletonList("vite-hmr");
            ServerEndpointConfig endpointConfig = ServerEndpointConfig.Builder.create(ViteWebsocketEndpoint.class, (String)viteHandler.getPathToVaadinInContext()).subprotocols(subProtocols).build();
            endpointConfig.getUserProperties().put(VITE_HANDLER, viteHandler);
            container.addEndpoint(endpointConfig);
        }
        catch (DeploymentException e) {
            ViteWebsocketEndpoint.getLogger().error("Error deploying Vite websocket proxy endpoint", (Throwable)e);
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        ViteWebsocketEndpoint.getLogger().debug("Browser ({}) connected to Vite proxy", (Object)session.getId());
        session.setMaxIdleTimeout(60000L);
        ViteHandler viteHandler = (ViteHandler)config.getUserProperties().get(VITE_HANDLER);
        try {
            ViteWebsocketProxy proxy = new ViteWebsocketProxy(session, viteHandler.getPort(), viteHandler.getPathToVaadin());
            proxies.put(session.getId(), proxy);
            session.addMessageHandler((MessageHandler)proxy);
        }
        catch (Exception e) {
            ViteWebsocketEndpoint.getLogger().error("Error creating Vite proxy connection", (Throwable)e);
            try {
                session.close();
            }
            catch (IOException e1) {
                ViteWebsocketEndpoint.getLogger().debug("Error closing connection", (Throwable)e1);
            }
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        ViteWebsocketEndpoint.getLogger().debug("Browser ({}) closed the connection", (Object)session.getId());
        ViteWebsocketProxy proxy = proxies.remove(session.getId());
        if (proxy != null) {
            proxy.close();
        }
        super.onClose(session, closeReason);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ViteWebsocketEndpoint.class);
    }
}

