/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.vaadin.signals.Id;
import com.vaadin.signals.Signal;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.ValueSignal;
import com.vaadin.signals.impl.SignalTree;
import com.vaadin.signals.operations.SignalOperation;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Predicate;

public class NumberSignal
extends ValueSignal<Double> {
    public NumberSignal() {
        super(0.0);
    }

    public NumberSignal(double initialValue) {
        super(initialValue);
    }

    protected NumberSignal(SignalTree tree, Id id, Predicate<SignalCommand> validator) {
        super(tree, id, validator, Double.class);
    }

    public SignalOperation<Double> incrementBy(double delta) {
        return this.submit(new SignalCommand.IncrementCommand(Id.random(), this.id(), delta), success -> NumberSignal.nodeValue(success.onlyUpdate().newNode(), Double.class));
    }

    @Override
    public Double value() {
        Double value = (Double)super.value();
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public int valueAsInt() {
        return this.value().intValue();
    }

    @Override
    public SignalOperation<Double> value(int value) {
        return this.value(Double.valueOf(value));
    }

    public NumberSignal withValidator(Predicate<SignalCommand> validator) {
        return new NumberSignal(this.tree(), this.id(), this.mergeValidators(validator));
    }

    @Override
    public NumberSignal asReadonly() {
        return this.withValidator(anything -> false);
    }

    public <C> Signal<C> mapIntValue(IntFunction<C> mapper) {
        return this.map(doubleValue -> mapper.apply(doubleValue.intValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof NumberSignal)) return false;
        NumberSignal other = (NumberSignal)obj;
        if (!Objects.equals(this.tree(), other.tree())) return false;
        if (!Objects.equals(this.id(), other.id())) return false;
        if (!Objects.equals(this.validator(), other.validator())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tree(), this.id(), this.validator());
    }

    @Override
    public String toString() {
        return "NumberSignal[" + String.valueOf(this.peek()) + "]";
    }
}

