/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.Product;

public class MissingLicenseKeyException
extends LicenseException {
    private final String productName;
    private final String productVersion;

    public MissingLicenseKeyException(Product product, String message) {
        super(MissingLicenseKeyException.buildMessage(product, message));
        this.productName = product.getName();
        this.productVersion = product.getVersion();
    }

    public MissingLicenseKeyException(Product product) {
        this(product, null);
    }

    public MissingLicenseKeyException(String message) {
        super(message);
        this.productName = null;
        this.productVersion = null;
    }

    private static String buildMessage(Product product, String message) {
        String out = "A license is required to use " + product.getName() + " " + product.getVersion();
        if (message != null) {
            out = out + ". " + message;
        }
        return out;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }
}

