/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.startup;

import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import com.vaadin.hilla.BrowserCallable;
import com.vaadin.hilla.Endpoint;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;

@HandlesTypes(value={Endpoint.class, BrowserCallable.class})
public class EndpointsValidator
implements ClassLoaderAwareServletContainerInitializer,
Serializable {
    private String classToCheck = "org.springframework.boot.autoconfigure.jackson.JacksonProperties";

    public void process(Set<Class<?>> classSet, ServletContext servletContext) throws ServletException {
        if (classSet == null) {
            return;
        }
        ClassFinder.DefaultClassFinder finder = new ClassFinder.DefaultClassFinder(classSet);
        Set endpoints = finder.getAnnotatedClasses(Endpoint.class);
        endpoints.addAll(finder.getAnnotatedClasses(BrowserCallable.class));
        if (!endpoints.isEmpty()) {
            try {
                finder.loadClass(this.classToCheck);
            }
            catch (ClassNotFoundException e) {
                throw new ServletException("ERROR: Vaadin endpoints only work for Spring enabled projects.\nThis is not a spring application but there are Vaadin endpoints in these classes: " + endpoints.stream().map(Class::getName).collect(Collectors.joining("\n    - ")), (Throwable)e);
            }
        }
    }

    void setClassToCheck(String className) {
        this.classToCheck = className;
    }
}

