/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.hilla.signals.ValueSignal;
import com.vaadin.hilla.signals.core.event.InvalidEventTypeException;
import com.vaadin.hilla.signals.core.event.MissingFieldException;
import com.vaadin.hilla.signals.core.event.StateEvent;
import com.vaadin.hilla.signals.operation.IncrementOperation;
import com.vaadin.hilla.signals.operation.OperationValidator;
import com.vaadin.hilla.signals.operation.ReplaceValueOperation;
import com.vaadin.hilla.signals.operation.SetValueOperation;
import com.vaadin.hilla.signals.operation.ValidationResult;
import java.util.Objects;

public class NumberSignal
extends ValueSignal<Double> {
    public NumberSignal(Double defaultValue) {
        super(defaultValue, Double.class);
    }

    public NumberSignal() {
        this(0.0);
    }

    protected NumberSignal(NumberSignal delegate) {
        super(delegate);
    }

    @Override
    protected NumberSignal getDelegate() {
        return (NumberSignal)super.getDelegate();
    }

    @Override
    protected ObjectNode processEvent(ObjectNode event) {
        try {
            StateEvent<Double> stateEvent = new StateEvent<Double>(event, Double.class);
            if (!StateEvent.EventType.INCREMENT.equals((Object)stateEvent.getEventType())) {
                return super.processEvent(event);
            }
            return this.handleIncrement(stateEvent);
        }
        catch (InvalidEventTypeException | MissingFieldException e) {
            throw new UnsupportedOperationException("Unsupported JSON: " + event, e);
        }
    }

    protected ObjectNode handleIncrement(StateEvent<Double> stateEvent) {
        if (this.getDelegate() != null) {
            return this.getDelegate().handleIncrement(stateEvent);
        }
        Double expectedValue = (Double)this.getValue();
        Double newValue = expectedValue + stateEvent.getValue();
        boolean accepted = super.compareAndSet(newValue, expectedValue);
        stateEvent.setAccepted(accepted);
        return stateEvent.toJson();
    }

    public NumberSignal withOperationValidator(OperationValidator<Double> validator) {
        Objects.requireNonNull(validator, "Validator cannot be null");
        return new ValidatedNumberSignal(this, validator);
    }

    @Override
    public NumberSignal asReadonly() {
        return this.withOperationValidator(op -> ValidationResult.reject("Read-only signal does not allow any modifications"));
    }

    private static class ValidatedNumberSignal
    extends NumberSignal {
        private final OperationValidator<Double> validator;

        private ValidatedNumberSignal(NumberSignal delegate, OperationValidator<Double> validator) {
            super(delegate);
            this.validator = validator;
        }

        @Override
        protected ObjectNode handleIncrement(StateEvent<Double> stateEvent) {
            IncrementOperation operation = IncrementOperation.of(stateEvent.getId(), stateEvent.getValue());
            ValidationResult validationResult = this.validator.validate(operation);
            return this.handleValidationResult(stateEvent, validationResult, x$0 -> super.handleIncrement((StateEvent<Double>)x$0));
        }

        @Override
        protected ObjectNode handleSetEvent(StateEvent<Double> stateEvent) {
            SetValueOperation<Double> operation = SetValueOperation.of(stateEvent.getId(), stateEvent.getValue());
            ValidationResult validation = this.validator.validate(operation);
            return this.handleValidationResult(stateEvent, validation, x$0 -> super.handleSetEvent(x$0));
        }

        @Override
        protected ObjectNode handleReplaceEvent(StateEvent<Double> stateEvent) {
            ReplaceValueOperation<Double> operation = ReplaceValueOperation.of(stateEvent.getId(), stateEvent.getExpected(), stateEvent.getValue());
            ValidationResult validation = this.validator.validate(operation);
            return this.handleValidationResult(stateEvent, validation, x$0 -> super.handleReplaceEvent(x$0));
        }
    }
}

