/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.dau.DAUUtils;
import com.vaadin.flow.server.dau.EnforcementNotificationMessages;
import com.vaadin.hilla.BrowserCallable;
import com.vaadin.hilla.Endpoint;
import com.vaadin.hilla.EndpointControllerConfiguration;
import com.vaadin.hilla.EndpointInvocationException;
import com.vaadin.hilla.EndpointInvoker;
import com.vaadin.hilla.EndpointProperties;
import com.vaadin.hilla.EndpointRegistry;
import com.vaadin.hilla.HillaStats;
import com.vaadin.hilla.auth.CsrfChecker;
import com.vaadin.hilla.exception.EndpointException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Import(value={EndpointControllerConfiguration.class, EndpointProperties.class})
public class EndpointController {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointController.class);
    static final String ENDPOINT_METHODS = "/{endpoint}/{method}";
    public static final String ENDPOINT_MAPPER_FACTORY_BEAN_QUALIFIER = "endpointMapperFactory";
    private static final String SIGNALS_HANDLER_BEAN_NAME = "signalsHandler";
    private final ApplicationContext context;
    EndpointRegistry endpointRegistry;
    private final CsrfChecker csrfChecker;
    private final EndpointInvoker endpointInvoker;
    VaadinService vaadinService;

    public EndpointController(ApplicationContext context, EndpointRegistry endpointRegistry, EndpointInvoker endpointInvoker, CsrfChecker csrfChecker) {
        this.context = context;
        this.endpointInvoker = endpointInvoker;
        this.csrfChecker = csrfChecker;
        this.endpointRegistry = endpointRegistry;
    }

    public void registerEndpoints(URL openApiResource) {
        VaadinService vaadinService;
        Object signalHandlerBean;
        TreeMap<String, Object> endpointBeans = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        endpointBeans.putAll(this.context.getBeansWithAnnotation(Endpoint.class));
        endpointBeans.putAll(this.context.getBeansWithAnnotation(BrowserCallable.class));
        this.registerEndpointsFromApiDefinition(endpointBeans, openApiResource);
        if (this.endpointRegistry.isEmpty() && !endpointBeans.isEmpty()) {
            LOGGER.debug("No endpoints found in openapi.json: registering all endpoints found using the Spring context");
            endpointBeans.forEach((name, endpointBean) -> this.endpointRegistry.registerEndpoint(endpointBean));
        }
        if (!this.endpointRegistry.isEmpty()) {
            HillaStats.reportHasEndpoint();
        }
        if (this.endpointRegistry.get(SIGNALS_HANDLER_BEAN_NAME) == null && (signalHandlerBean = endpointBeans.get(SIGNALS_HANDLER_BEAN_NAME)) != null) {
            this.endpointRegistry.registerEndpoint(signalHandlerBean);
        }
        if ((vaadinService = VaadinService.getCurrent()) != null) {
            this.vaadinService = vaadinService;
        }
    }

    @PostMapping(path={"/{endpoint}/{method}"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> serveEndpoint(@PathVariable(value="endpoint") String endpointName, @PathVariable(value="method") String methodName, @RequestBody(required=false) ObjectNode body, HttpServletRequest request, HttpServletResponse response) {
        return this.doServeEndpoint(endpointName, methodName, body, request, response);
    }

    public ResponseEntity<String> serveEndpoint(String endpointName, String methodName, ObjectNode body, HttpServletRequest request) {
        return this.doServeEndpoint(endpointName, methodName, body, request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseEntity<String> doServeEndpoint(String endpointName, String methodName, ObjectNode body, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("Endpoint: {}, method: {}, request body: {}", new Object[]{endpointName, methodName, body});
        if (!this.csrfChecker.validateCsrfTokenInRequest(request)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)this.endpointInvoker.createResponseErrorObject("Access denied"));
        }
        DAUUtils.EnforcementResult enforcementResult = null;
        try {
            enforcementResult = DAUUtils.trackDAU((VaadinService)this.vaadinService, (HttpServletRequest)request, (HttpServletResponse)response);
            if (enforcementResult.isEnforcementNeeded()) {
                ResponseEntity<String> responseEntity = this.buildEnforcementResponseEntity(enforcementResult);
                return responseEntity;
            }
            Object returnValue = this.endpointInvoker.invoke(endpointName, methodName, body, request.getUserPrincipal(), arg_0 -> ((HttpServletRequest)request).isUserInRole(arg_0));
            try {
                ResponseEntity responseEntity = ResponseEntity.ok((Object)this.endpointInvoker.writeValueAsString(returnValue));
                return responseEntity;
            }
            catch (JsonProcessingException e3) {
                try {
                    String errorMessage = String.format("Failed to serialize endpoint '%s' method '%s' response. Double check method's return type or specify a custom mapper bean with qualifier '%s'", endpointName, methodName, ENDPOINT_MAPPER_FACTORY_BEAN_QUALIFIER);
                    LOGGER.error(errorMessage, (Throwable)e3);
                    throw new EndpointInvocationException.EndpointInternalException(errorMessage);
                }
                catch (EndpointException e2) {
                    try {
                        ResponseEntity e3 = ResponseEntity.badRequest().body((Object)this.endpointInvoker.createResponseErrorObject(e2.getSerializationData()));
                        return e3;
                    }
                    catch (JsonProcessingException ee) {
                        String errorMessage = "Failed to serialize error object for endpoint exception. ";
                        LOGGER.error(errorMessage, (Throwable)e2);
                        ResponseEntity responseEntity = ResponseEntity.internalServerError().body((Object)errorMessage);
                        return responseEntity;
                    }
                }
                catch (EndpointInvocationException.EndpointNotFoundException e4) {
                    ResponseEntity responseEntity = ResponseEntity.notFound().build();
                    return responseEntity;
                }
                catch (EndpointInvocationException.EndpointAccessDeniedException e5) {
                    ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)this.endpointInvoker.createResponseErrorObject(e5.getMessage()));
                    return responseEntity;
                }
                catch (EndpointInvocationException.EndpointBadRequestException e6) {
                    ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)this.endpointInvoker.createResponseErrorObject(e6.getMessage()));
                    return responseEntity;
                }
                catch (EndpointInvocationException.EndpointInternalException e7) {
                    ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.endpointInvoker.createResponseErrorObject(e7.getMessage()));
                    return responseEntity;
                }
            }
        }
        finally {
            if (enforcementResult != null && enforcementResult.endRequestAction() != null) {
                enforcementResult.endRequestAction().run();
            } else {
                CurrentInstance.set(VaadinRequest.class, null);
            }
        }
    }

    private ResponseEntity<String> buildEnforcementResponseEntity(DAUUtils.EnforcementResult enforcementResult) {
        EnforcementNotificationMessages messages = enforcementResult.messages();
        EndpointException endpointException = new EndpointException(messages.caption(), enforcementResult.origin(), messages);
        try {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).body((Object)this.endpointInvoker.createResponseErrorObject(endpointException.getSerializationData()));
        }
        catch (JsonProcessingException ee) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).body((Object)this.endpointInvoker.createResponseErrorObject(messages.caption() + ". " + messages.message()));
        }
    }

    private void registerEndpointsFromApiDefinition(Map<String, Object> knownEndpointBeans, URL openApiResource) {
        if (openApiResource == null) {
            LOGGER.debug("Resource 'hilla-openapi.json' is not available: endpoints cannot be registered yet");
        } else {
            try (InputStream stream = openApiResource.openStream();){
                JsonNode rootNode = new ObjectMapper().readTree(stream);
                ArrayNode tagsNode = (ArrayNode)rootNode.get("tags");
                if (tagsNode != null) {
                    tagsNode.forEach(tag -> Optional.ofNullable(tag.get("name")).map(JsonNode::asText).map(knownEndpointBeans::get).or(() -> Optional.ofNullable(tag.get("x-class-name")).map(JsonNode::asText).map(this::instantiateEndpointByClassName)).ifPresent(this.endpointRegistry::registerEndpoint));
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read openapi.json", (Throwable)e);
            }
        }
    }

    private Object instantiateEndpointByClassName(String className) {
        Class<?> cls;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Endpoint class {} is not available", (Object)className, (Object)e);
            return null;
        }
        try {
            Object endpoint = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LOGGER.warn("Endpoint '{}' is not a Spring bean and has been instantiated using default constructor. This is not guaranteed to be supported in future releases.", (Object)className);
            return endpoint;
        }
        catch (ReflectiveOperationException ex) {
            LOGGER.error("Endpoint '{}' is not a Spring bean and cannot be instantiated.", (Object)className);
            return null;
        }
    }
}

