/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.hilla.ApplicationContextProvider;
import com.vaadin.hilla.EndpointController;
import com.vaadin.hilla.OpenAPIUtil;
import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.GeneratorProcessor;
import com.vaadin.hilla.engine.ParserProcessor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EndpointCodeGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointCodeGenerator.class);
    private final EndpointController endpointController;
    private final VaadinContext context;
    private Path buildDirectory;
    private ApplicationConfiguration configuration;
    private String nodeExecutable;
    private Set<String> classesUsedInOpenApi = null;

    public EndpointCodeGenerator(VaadinContext context, EndpointController endpointController) {
        this.endpointController = endpointController;
        this.context = context;
    }

    public static EndpointCodeGenerator getInstance() {
        return (EndpointCodeGenerator)ApplicationContextProvider.getApplicationContext().getBean(EndpointCodeGenerator.class);
    }

    public void update() throws IOException {
        this.initIfNeeded();
        if (this.configuration.isProductionMode()) {
            throw new IllegalStateException("This method is not available in production mode");
        }
        EngineConfiguration engineConfiguration = EngineConfiguration.loadDirectory((Path)this.buildDirectory);
        ParserProcessor parser = new ParserProcessor(engineConfiguration, this.getClass().getClassLoader(), false);
        parser.process();
        GeneratorProcessor generator = new GeneratorProcessor(engineConfiguration, this.nodeExecutable, false);
        generator.process();
        OpenAPIUtil.getCurrentOpenAPIPath(this.buildDirectory, false).ifPresent(openApiPath -> {
            try {
                this.endpointController.registerEndpoints(openApiPath.toUri().toURL());
            }
            catch (IOException e) {
                LOGGER.error("Endpoints could not be registered due to an exception: ", (Throwable)e);
            }
        });
    }

    private void initIfNeeded() {
        if (this.configuration == null) {
            this.configuration = ApplicationConfiguration.get((VaadinContext)this.context);
            Path projectFolder = this.configuration.getProjectFolder().toPath();
            this.buildDirectory = projectFolder.resolve(this.configuration.getBuildFolder());
            FrontendTools tools = new FrontendTools(this.configuration, this.configuration.getProjectFolder());
            this.nodeExecutable = tools.getNodeBinary();
        }
    }

    public Optional<Set<String>> getClassesUsedInOpenApi() throws IOException {
        if (this.classesUsedInOpenApi == null) {
            this.initIfNeeded();
            OpenAPIUtil.getCurrentOpenAPIPath(this.buildDirectory, false).ifPresent(openApiPath -> {
                if (openApiPath.toFile().exists()) {
                    try {
                        this.classesUsedInOpenApi = OpenAPIUtil.findOpenApiClasses(Files.readString(openApiPath));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    LOGGER.debug("No OpenAPI file is available yet ...");
                }
            });
        }
        return Optional.ofNullable(this.classesUsedInOpenApi);
    }
}

