/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.core.event;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Objects;

public class StateEvent<T> {
    static final ObjectMapper MAPPER = new ObjectMapper();
    private final String id;
    private final EventType eventType;
    private final T value;
    private final T expected;

    public StateEvent(String id, EventType eventType, T value, T expected) {
        this.id = id;
        this.eventType = eventType;
        this.value = value;
        this.expected = expected;
    }

    public StateEvent(String id, EventType eventType, T value) {
        this(id, eventType, value, null);
    }

    public StateEvent(ObjectNode json, Class<T> valueType) {
        this.id = this.extractId((JsonNode)json);
        this.eventType = this.extractEventType((JsonNode)json);
        this.value = this.convertValue(this.extractValue((JsonNode)json), valueType);
        JsonNode expected = json.get("expected");
        this.expected = this.convertValue(expected, valueType);
    }

    private T convertValue(JsonNode rawValue, Class<T> valueType) {
        if (rawValue == null) {
            return null;
        }
        return (T)MAPPER.convertValue((Object)rawValue, valueType);
    }

    private String extractId(JsonNode json) {
        JsonNode id = json.get("id");
        if (id == null) {
            throw new MissingFieldException("id");
        }
        return id.asText();
    }

    private JsonNode extractValue(JsonNode json) {
        JsonNode value = json.get("value");
        if (value == null) {
            throw new MissingFieldException("value");
        }
        return value;
    }

    private EventType extractEventType(JsonNode json) {
        JsonNode rawType = json.get("type");
        if (rawType == null) {
            String message = String.format("Missing event type. Type is required, and should be one of: %s", Arrays.toString((Object[])EventType.values()));
            throw new InvalidEventTypeException(message);
        }
        try {
            return EventType.valueOf(rawType.asText().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Invalid event type %s. Type should be one of: %s", rawType.asText(), Arrays.toString((Object[])EventType.values()));
            throw new InvalidEventTypeException(message, e);
        }
    }

    public ObjectNode toJson() {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("id", this.id);
        json.put("type", this.eventType.name().toLowerCase());
        json.set("value", this.valueAsJsonNode(this.getValue()));
        if (this.getExpected() != null) {
            json.set("expected", this.valueAsJsonNode(this.getExpected()));
        }
        return json;
    }

    public static ObjectNode setAccepted(ObjectNode event, boolean accepted) {
        return event.put("accepted", accepted);
    }

    public static boolean isAccepted(ObjectNode event) {
        return event.has("accepted") && event.get("accepted").asBoolean();
    }

    private JsonNode valueAsJsonNode(T value) {
        return MAPPER.valueToTree(value);
    }

    public String getId() {
        return this.id;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public T getValue() {
        return this.value;
    }

    public T getExpected() {
        return this.expected;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StateEvent)) {
            return false;
        }
        StateEvent that = (StateEvent)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public static enum EventType {
        SNAPSHOT,
        SET,
        REPLACE,
        INCREMENT;

    }

    public static final class Field {
        public static final String ID = "id";
        public static final String TYPE = "type";
        public static final String VALUE = "value";
        public static final String EXPECTED = "expected";
        public static final String ACCEPTED = "accepted";
    }

    public static class MissingFieldException
    extends RuntimeException {
        public MissingFieldException(String fieldName) {
            super("Missing field: " + fieldName);
        }
    }

    public static class InvalidEventTypeException
    extends RuntimeException {
        public InvalidEventTypeException(String message) {
            super(message);
        }

        public InvalidEventTypeException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

