/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.hilla.signals.core.event.StateEvent;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public abstract class Signal<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Signal.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final UUID id = UUID.randomUUID();
    private final Class<T> valueType;
    private final Set<Sinks.Many<ObjectNode>> subscribers = new HashSet<Sinks.Many<ObjectNode>>();

    public Signal(Class<T> valueType) {
        this.valueType = Objects.requireNonNull(valueType);
    }

    public UUID getId() {
        return this.id;
    }

    public Class<T> getValueType() {
        return this.valueType;
    }

    public Flux<ObjectNode> subscribe() {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        return sink.asFlux().doOnSubscribe(ignore -> {
            LOGGER.debug("New Flux subscription...");
            this.lock.lock();
            try {
                ObjectNode snapshot = this.createSnapshotEvent();
                sink.tryEmitNext((Object)snapshot);
                this.subscribers.add((Sinks.Many<ObjectNode>)sink);
            }
            finally {
                this.lock.unlock();
            }
        }).doFinally(ignore -> {
            this.lock.lock();
            try {
                LOGGER.debug("Unsubscribing from Signal...");
                this.subscribers.remove(sink);
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    public void submit(ObjectNode event) {
        this.lock.lock();
        try {
            boolean accepted = this.processEvent(event);
            this.subscribers.removeIf(sink -> {
                ObjectNode eventWithStatus = StateEvent.setAccepted(event, accepted);
                boolean failure = sink.tryEmitNext((Object)eventWithStatus).isFailure();
                if (failure) {
                    LOGGER.debug("Failed push");
                }
                return failure;
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract ObjectNode createSnapshotEvent();

    protected abstract boolean processEvent(ObjectNode var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Signal)) {
            return false;
        }
        Signal signal = (Signal)o;
        return Objects.equals(this.getId(), signal.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }
}

