/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.ContentTypeResolver;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResourceWriter;
import com.vaadin.flow.server.VaadinSession;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.LoggerFactory;

@Deprecated(since="24.8", forRemoval=true)
public class StreamResource
extends AbstractStreamResource {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final DefaultResolver DEFAULT_RESOLVER = new DefaultResolver();
    private final String fileName;
    private final StreamResourceWriter writer;
    private ContentTypeResolver resolver = DEFAULT_RESOLVER;
    private Map<String, String> headers;

    public StreamResource(String name, StreamResourceWriter writer) {
        assert (name != null);
        assert (writer != null);
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Resource file name parameter contains '/'");
        }
        this.fileName = name;
        this.writer = writer;
    }

    public StreamResource(String name, InputStreamFactory factory) {
        this(name, new Pipe(factory));
        assert (name != null);
    }

    public StreamResourceWriter getWriter() {
        return this.writer;
    }

    public StreamResource setContentTypeResolver(ContentTypeResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("Resolver cannot be null");
        }
        this.resolver = resolver;
        return this;
    }

    public StreamResource setContentType(String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("Content type cannot be null");
        }
        this.setContentTypeResolver((resource, context) -> contentType);
        return this;
    }

    public ContentTypeResolver getContentTypeResolver() {
        return this.resolver;
    }

    public StreamResource setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }

    public Optional<String> getHeader(String name) {
        if (this.headers != null) {
            return Optional.ofNullable(this.headers.get(name));
        }
        return Optional.empty();
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    private static class DefaultResolver
    implements ContentTypeResolver {
        private DefaultResolver() {
        }

        @Override
        public String apply(StreamResource resource, ServletContext context) {
            return Optional.ofNullable(context.getMimeType(resource.getName())).orElse(StreamResource.DEFAULT_CONTENT_TYPE);
        }
    }

    private static class Pipe
    implements StreamResourceWriter {
        private static final int BUFFER_SIZE = 1024;
        private InputStreamFactory factory;

        private Pipe(InputStreamFactory factory) {
            this.factory = factory;
        }

        @Override
        public void accept(OutputStream stream, VaadinSession session) throws IOException {
            try (InputStream input = this.createInputStream(session);){
                this.copy(session, input, stream);
            }
            catch (IOException ioe) {
                if ("Broken pipe".equals(ioe.getMessage())) {
                    LoggerFactory.getLogger(StreamResource.class).debug("The client browser has most likely cancelled the request.", (Throwable)ioe);
                }
                throw ioe;
            }
        }

        private InputStream createInputStream(VaadinSession session) {
            session.lock();
            try {
                InputStream inputStream = this.factory.createInputStream();
                return inputStream;
            }
            finally {
                session.unlock();
            }
        }

        private void copy(VaadinSession session, InputStream source, OutputStream out) throws IOException {
            int n;
            byte[] buf = new byte[1024];
            while ((n = this.read(session, source, buf)) >= 0) {
                out.write(buf, 0, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int read(VaadinSession session, InputStream source, byte[] buffer) throws IOException {
            if (this.factory.requiresLock()) {
                session.lock();
                try {
                    int n = source.read(buffer);
                    return n;
                }
                finally {
                    session.unlock();
                }
            }
            return source.read(buffer);
        }
    }
}

