/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;

public class LocalDateTimeToDateConverter
implements Converter<LocalDateTime, Date> {
    private ZoneId zoneId;

    public LocalDateTimeToDateConverter(ZoneId zoneId) {
        this.zoneId = Objects.requireNonNull(zoneId, "Zone identifier cannot be null");
    }

    @Override
    public Result<Date> convertToModel(LocalDateTime localDate, ValueContext context) {
        if (localDate == null) {
            return Result.ok(null);
        }
        return Result.ok(Date.from(localDate.atZone(this.zoneId).toInstant()));
    }

    @Override
    public LocalDateTime convertToPresentation(Date date, ValueContext context) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(this.zoneId).toLocalDateTime();
    }
}

