/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.data.provider.AbstractDataView;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.ItemIndexProvider;
import com.vaadin.flow.data.provider.LazyDataView;
import com.vaadin.flow.data.provider.Query;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class AbstractLazyDataView<T>
extends AbstractDataView<T>
implements LazyDataView<T> {
    private final DataCommunicator<T> dataCommunicator;

    public AbstractLazyDataView(DataCommunicator<T> dataCommunicator, Component component) {
        super(dataCommunicator::getDataProvider, component);
        this.dataCommunicator = dataCommunicator;
    }

    protected DataCommunicator<T> getDataCommunicator() {
        this.verifyDataProviderType(this.dataCommunicator.getDataProvider());
        return this.dataCommunicator;
    }

    @Override
    public T getItem(int index) {
        return this.getDataCommunicator().getItem(index);
    }

    @Override
    public Optional<Integer> getItemIndex(T item) {
        if (this.getItemIndexProvider() == null) {
            throw new UnsupportedOperationException("getItemIndex method in the LazyDataView requires a callback to fetch the index. Set it with setItemIndexProvider.");
        }
        return Optional.ofNullable(this.getItemIndexProvider().apply(item, this.getFilteredQueryForAllItems()));
    }

    @Override
    public Stream<T> getItems() {
        DataCommunicator<T> verifiedDataCommunicator = this.getDataCommunicator();
        return verifiedDataCommunicator.getDataProvider().fetch(this.getQueryForAllItems());
    }

    @Override
    public Stream<T> getItems(int offset, int limit) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset must be non-negative");
        }
        if (limit < 0) {
            throw new IndexOutOfBoundsException("Limit must be non-negative");
        }
        if (limit == 0) {
            return Stream.empty();
        }
        DataCommunicator<T> verifiedDataCommunicator = this.getDataCommunicator();
        if (verifiedDataCommunicator.isDefinedSize()) {
            int count = verifiedDataCommunicator.getItemCount();
            if (offset >= count) {
                return Stream.empty();
            }
            int effectiveLimit = Math.min(limit, count - offset);
            return verifiedDataCommunicator.getDataProvider().fetch(verifiedDataCommunicator.buildQuery(offset, effectiveLimit));
        }
        return verifiedDataCommunicator.getDataProvider().fetch(verifiedDataCommunicator.buildQuery(offset, limit));
    }

    @Override
    protected Class<?> getSupportedDataProviderType() {
        return BackEndDataProvider.class;
    }

    @Override
    public void setItemCountEstimate(int itemCountEstimate) {
        this.getDataCommunicator().setItemCountEstimate(itemCountEstimate);
    }

    @Override
    public int getItemCountEstimate() {
        return this.getDataCommunicator().getItemCountEstimate();
    }

    @Override
    public void setItemCountEstimateIncrease(int itemCountEstimateIncrease) {
        this.getDataCommunicator().setItemCountEstimateIncrease(itemCountEstimateIncrease);
    }

    @Override
    public int getItemCountEstimateIncrease() {
        return this.getDataCommunicator().getItemCountEstimateIncrease();
    }

    @Override
    public void setItemCountFromDataProvider() {
        this.getDataCommunicator().setDefinedSize(true);
    }

    @Override
    public void setItemCountUnknown() {
        this.getDataCommunicator().setDefinedSize(false);
    }

    @Override
    public void setItemIndexProvider(ItemIndexProvider<T, ?> itemIndexProvider) {
        ComponentUtil.setData((Component)this.component, ItemIndexProvider.class, itemIndexProvider);
    }

    protected ItemIndexProvider<T, ?> getItemIndexProvider() {
        return (ItemIndexProvider)ComponentUtil.getData((Component)this.component, ItemIndexProvider.class);
    }

    private Query getQueryForAllItems() {
        DataCommunicator<T> verifiedDataCommunicator = this.getDataCommunicator();
        if (verifiedDataCommunicator.isDefinedSize()) {
            return verifiedDataCommunicator.buildQuery(0, verifiedDataCommunicator.getItemCount());
        }
        return verifiedDataCommunicator.buildQuery(0, Integer.MAX_VALUE);
    }

    private Query getFilteredQueryForAllItems() {
        Query baseQuery = this.getQueryForAllItems();
        if (DataProviderWrapper.class.isAssignableFrom(this.dataCommunicator.getDataProvider().getClass())) {
            DataProviderWrapper wrapper = (DataProviderWrapper)this.dataCommunicator.getDataProvider();
            return new Query(baseQuery.getOffset(), baseQuery.getLimit(), baseQuery.getSortOrders(), baseQuery.getInMemorySorting(), wrapper.getFilter(baseQuery));
        }
        return baseQuery;
    }
}

