/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.themeeditor;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithBlockStmt;
import com.github.javaparser.ast.nodeTypes.NodeWithExpression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.plugins.themeeditor.CopilotEditor;
import com.vaadin.copilot.plugins.themeeditor.Editor;
import com.vaadin.copilot.plugins.themeeditor.Where;
import com.vaadin.copilot.plugins.themeeditor.utils.LineNumberVisitor;
import com.vaadin.copilot.plugins.themeeditor.utils.LocalClassNameVisitor;
import com.vaadin.copilot.plugins.themeeditor.utils.LocalClassNamesVisitor;
import com.vaadin.copilot.plugins.themeeditor.utils.ThemeEditorException;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.util.SharedUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSourceModifier
extends CopilotEditor {
    private static final String LOCAL_CLASSNAME_COMMENT = "<theme-editor-local-classname>";
    private static final String CANNOT_GENERATE_METADATA = "Cannot generate metadata.";

    public static boolean hasLocalClassnameComment(Node n) {
        return n.getComment().map(Comment::getContent).map(String::trim).filter(LOCAL_CLASSNAME_COMMENT::equals).isPresent();
    }

    public JavaSourceModifier(ProjectManager projectManager) {
        super(projectManager);
    }

    public void setLocalClassName(Integer uiId, Integer nodeId, String className) {
        assert (uiId != null && nodeId != null && className != null);
        ComponentTypeAndSourceLocation componentSource = this.sourceFinder.findTypeAndSourceLocation(uiId, nodeId);
        try {
            this.setLocalClassName(componentSource, className, false);
            if (this.hasOverlay(componentSource)) {
                this.setLocalClassName(componentSource, className, true);
            }
        }
        catch (Exception e) {
            throw new ThemeEditorException("Cannot set local classname.", e);
        }
    }

    protected void setLocalClassName(ComponentTypeAndSourceLocation componentSource, String className, boolean overlay) {
        try {
            File sourceFile = componentSource.javaFile();
            int sourceOffset = this.modifyClass(sourceFile, cu -> {
                Editor.Modification mod;
                SimpleName scope = this.findLocalVariableOrField((CompilationUnit)cu, componentSource.getCreateLocationOrThrow().lineNumber());
                Statement newNode = this.createAddClassNameStatement(scope, className, overlay);
                ExpressionStmt stmt = this.findLocalClassNameStmt((CompilationUnit)cu, componentSource, overlay);
                if (stmt == null) {
                    Node node = this.findNode((CompilationUnit)cu, componentSource);
                    Where where = this.findModificationWhere((CompilationUnit)cu, componentSource);
                    mod = switch (where) {
                        default -> throw new IncompatibleClassChangeError();
                        case Where.AFTER -> Editor.Modification.insertLineAfter(node, (Node)newNode);
                        case Where.INSIDE -> Editor.Modification.insertAtEndOfBlock(node, (Node)newNode);
                        case Where.BEFORE -> Editor.Modification.insertLineBefore(node, (Node)newNode);
                    };
                } else {
                    mod = Editor.Modification.replace((Node)stmt, (Node)newNode);
                }
                return Collections.singletonList(mod);
            });
            if (sourceOffset != 0) {
                ComponentTracker.refreshLocation((ComponentTracker.Location)componentSource.getCreateLocationOrThrow(), (int)sourceOffset);
            }
        }
        catch (UnsupportedOperationException ex) {
            throw new ThemeEditorException(ex);
        }
    }

    public String getTag(Integer uiId, Integer nodeId) {
        assert (uiId != null && nodeId != null);
        ComponentTypeAndSourceLocation componentSource = this.sourceFinder.findTypeAndSourceLocation(uiId, nodeId);
        try {
            return componentSource.component().getElement().getTag();
        }
        catch (Exception e) {
            throw new ThemeEditorException("Cannot get tag of component.", e);
        }
    }

    public String getLocalClassName(Integer uiId, Integer nodeId) {
        assert (uiId != null && nodeId != null);
        try {
            ComponentTypeAndSourceLocation componentSource = this.sourceFinder.findTypeAndSourceLocation(uiId, nodeId);
            CompilationUnit cu = this.getCompilationUnit(componentSource);
            ExpressionStmt localClassNameStmt = this.findLocalClassNameStmt(cu, componentSource, false);
            if (localClassNameStmt != null) {
                return localClassNameStmt.getExpression().asMethodCallExpr().getArgument(0).asStringLiteralExpr().asString();
            }
            return null;
        }
        catch (IOException e) {
            throw new ThemeEditorException("Cannot get local classname.", e);
        }
    }

    public void removeLocalClassName(Integer uiId, Integer nodeId) {
        assert (uiId != null && nodeId != null);
        ComponentTypeAndSourceLocation componentSource = this.sourceFinder.findTypeAndSourceLocation(uiId, nodeId);
        try {
            this.removeLocalClassName(componentSource, false);
            if (this.hasOverlay(componentSource)) {
                this.removeLocalClassName(componentSource, true);
            }
        }
        catch (Exception e) {
            throw new ThemeEditorException("Cannot remove local classname.", e);
        }
    }

    public void removeLocalClassName(ComponentTypeAndSourceLocation componentSource, boolean overlay) {
        int sourceOffset = this.modifyClass(componentSource.javaFile(), cu -> {
            ExpressionStmt localClassNameStmt = this.findLocalClassNameStmt((CompilationUnit)cu, componentSource, overlay);
            if (localClassNameStmt != null) {
                return Collections.singletonList(Editor.Modification.remove((Node)localClassNameStmt));
            }
            throw new ThemeEditorException("Local classname not present.");
        });
        if (sourceOffset != 0) {
            ComponentTracker.refreshLocation((ComponentTracker.Location)componentSource.getCreateLocationOrThrow(), (int)sourceOffset);
        }
    }

    public boolean isAccessible(Integer uiId, Integer nodeId) {
        assert (uiId != null && nodeId != null);
        ComponentTypeAndSourceLocation componentSource = this.sourceFinder.findTypeAndSourceLocation(uiId, nodeId);
        try {
            CompilationUnit cu = this.getCompilationUnit(componentSource);
            this.findModificationWhere(cu, componentSource);
            return true;
        }
        catch (Exception ex) {
            JavaSourceModifier.getLogger().debug(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public String getSuggestedClassName(Integer uiId, Integer nodeId) {
        assert (uiId != null && nodeId != null);
        try {
            ComponentTypeAndSourceLocation componentSource = this.sourceFinder.findTypeAndSourceLocation(uiId, nodeId);
            ComponentTracker.Location createLocation = componentSource.getCreateLocationOrThrow();
            String fileName = SharedUtil.upperCamelCaseToDashSeparatedLowerCase((String)createLocation.filename().substring(0, createLocation.filename().indexOf(".")));
            String tagName = componentSource.component().getElement().getTag().replace("vaadin-", "");
            CompilationUnit cu = this.getCompilationUnit(componentSource);
            LocalClassNamesVisitor visitor = new LocalClassNamesVisitor();
            cu.accept((GenericVisitor)visitor, null);
            List<String> existingClassNames = visitor.getArguments();
            String suggestion = fileName + "-" + tagName + "-";
            return IntStream.range(1, 100).mapToObj(i -> suggestion + i).filter(i -> !existingClassNames.contains(i)).findFirst().orElse(null);
        }
        catch (Exception e) {
            throw new ThemeEditorException(CANNOT_GENERATE_METADATA, e);
        }
    }

    protected Statement createAddClassNameStatement(SimpleName scope, String className, boolean overlay) {
        MethodCallExpr methodCallExpr = new MethodCallExpr(overlay ? "setOverlayClassName" : "addClassName", new Expression[0]);
        if (scope != null) {
            methodCallExpr.setScope((Expression)new NameExpr(scope));
        }
        methodCallExpr.getArguments().add((Node)new StringLiteralExpr(className));
        ExpressionStmt statement = new ExpressionStmt((Expression)methodCallExpr);
        statement.setComment((Comment)new LineComment(LOCAL_CLASSNAME_COMMENT));
        return statement;
    }

    protected Component getComponent(VaadinSession session, int uiId, int nodeId) {
        Element element = session.findElement(uiId, nodeId);
        Optional c = element.getComponent();
        if (c.isEmpty()) {
            throw new ThemeEditorException("Only component locations are tracked. The given node id refers to an element and not a component.");
        }
        return (Component)c.get();
    }

    protected CompilationUnit getCompilationUnit(ComponentTypeAndSourceLocation componentSource) throws IOException {
        String source = this.projectManager.readFile(componentSource.javaFile());
        return new JavaRewriter(source).getCompilationUnit();
    }

    protected ExpressionStmt findLocalClassNameStmt(CompilationUnit cu, ComponentTypeAndSourceLocation componentSource, boolean overlay) {
        SimpleName scope = this.findLocalVariableOrField(cu, componentSource.getCreateLocationOrThrow().lineNumber());
        Node parentBlockNode = this.findParentBlockNode(cu, componentSource.component());
        return (ExpressionStmt)parentBlockNode.accept((GenericVisitor)new LocalClassNameVisitor(overlay), (Object)(scope != null ? scope.getIdentifier() : null));
    }

    protected Node findParentBlockNode(CompilationUnit cu, Component component) {
        ComponentTracker.Location createLocation = this.sourceFinder.findTypeAndSourceLocation(component, false).getCreateLocationOrThrow();
        Node node = (Node)cu.accept((GenericVisitor)new LineNumberVisitor(), (Object)createLocation.lineNumber());
        if (node instanceof BlockStmt) {
            return node;
        }
        while (node.getParentNode().isPresent()) {
            if (!((node = (Node)node.getParentNode().get()) instanceof BlockStmt)) continue;
            BlockStmt blockStmt = (BlockStmt)node;
            return blockStmt;
        }
        return cu;
    }

    protected Where findModificationWhere(CompilationUnit cu, ComponentTypeAndSourceLocation componentSource) {
        NodeWithExpression expr;
        Node node = this.findNode(cu, componentSource);
        if (node instanceof NodeWithBlockStmt) {
            return Where.INSIDE;
        }
        if (node instanceof NodeWithExpression && ((expr = (NodeWithExpression)node).getExpression().isAssignExpr() || expr.getExpression().isVariableDeclarationExpr())) {
            return Where.AFTER;
        }
        throw new ThemeEditorException("Cannot apply classname for " + String.valueOf(node));
    }

    protected Node findNode(CompilationUnit cu, ComponentTypeAndSourceLocation componentSource) {
        Node node = (Node)cu.accept((GenericVisitor)new LineNumberVisitor(), (Object)componentSource.getCreateLocationOrThrow().lineNumber());
        if (node == null) {
            throw new ThemeEditorException("Cannot find component.");
        }
        return node;
    }

    protected boolean hasOverlay(ComponentTypeAndSourceLocation componentSource) {
        try {
            componentSource.component().getClass().getMethod("setOverlayClassName", String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(JavaSourceModifier.class);
    }
}

