/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.codegen.jet.parser;

import com.tikal.codegen.jet.EmitterException;
import com.tikal.codegen.jet.ErrorCode;
import com.tikal.codegen.jet.ExpressionElement;
import com.tikal.codegen.jet.ScripletElement;
import com.tikal.codegen.jet.TemplateElement;
import com.tikal.codegen.jet.TextElement;
import com.tikal.codegen.jet.parser.JetLexer;
import com.tikal.codegen.jet.parser.JetParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateParser {
    private final URL templateURL;
    EmitterException faultReason = null;
    List<TemplateElement> elements = new ArrayList<TemplateElement>();
    private String className = "";
    private String packageName = "";
    private String skeleton = "";
    private String imports = "";

    public TemplateParser(URL templateURL) {
        this.templateURL = templateURL;
    }

    public boolean parse() throws IOException {
        this.elements.clear();
        return this.parseInternal(this.templateURL.openStream());
    }

    private boolean parseInternal(InputStream inputStream) {
        ANTLRInputStream stream = null;
        try {
            stream = new ANTLRInputStream(inputStream);
            JetLexer lexer = new JetLexer((CharStream)stream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            JetParser parser = new JetParser((TokenStream)tokens);
            parser.setTreeAdaptor((TreeAdaptor)new Adaptor());
            JetTree tree = (JetTree)((Object)parser.document().getTree());
            if (tree != null) {
                int count = tree.getChildCount();
                for (int i = 0; i < count; ++i) {
                    JetDirectiveTree directive;
                    JetTree child = (JetTree)tree.getChild(i);
                    if (child instanceof JetDirectiveTree && (directive = (JetDirectiveTree)child).getId() != null) {
                        if (directive.getId().equals("jet")) {
                            this.packageName = directive.getAttribute("package");
                            this.className = directive.getAttribute("class");
                            this.skeleton = directive.getAttribute("skeleton");
                            this.imports = directive.getAttribute("imports");
                        } else if (directive.getId().equals("include")) {
                            String file = directive.getAttribute("file");
                            if (file == null) {
                                throw new EmitterException(ErrorCode.INCLUDE_FILE_NAME_ABSENT);
                            }
                            URL url = this.getUrlForName(file);
                            this.parseInternal(url.openStream());
                        }
                    }
                    child.createElement();
                }
                this.postParseProcess();
                return true;
            }
            this.setFaultReason(new EmitterException(ErrorCode.TEMPLATE_PARSING_FAILED));
        }
        catch (IOException e) {
            this.setFaultReason(new EmitterException(ErrorCode.TEMPLATE_READ_FAILED, e.getMessage()));
        }
        catch (RecognitionException e) {
            this.setFaultReason(new EmitterException(ErrorCode.TEMPLATE_PARSING_FAILED, e.getMessage()));
        }
        return false;
    }

    private void postParseProcess() {
        boolean removeFirstNewLine = true;
        for (TemplateElement element : this.elements) {
            if (element instanceof ScripletElement) {
                removeFirstNewLine = true;
                continue;
            }
            if (element instanceof ExpressionElement) {
                removeFirstNewLine = false;
                continue;
            }
            if (!(element instanceof TextElement)) continue;
            if (removeFirstNewLine) {
                ((TextElement)element).removeFirstNewLine();
            }
            removeFirstNewLine = false;
        }
    }

    public EmitterException getFaultReason() {
        return this.faultReason;
    }

    public void setFaultReason(EmitterException faultReason) {
        this.faultReason = faultReason;
    }

    public List<TemplateElement> getElements() {
        return this.elements;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSkeleton() {
        return this.skeleton;
    }

    public String getImports() {
        return this.imports;
    }

    URL getUrlForName(String fileName) {
        String templateURLName = this.templateURL.toString();
        int pos = templateURLName.lastIndexOf("/");
        if (pos >= 0) {
            String urlString = templateURLName.substring(0, pos + 1) + fileName;
            try {
                return new URL(urlString);
            }
            catch (MalformedURLException e) {
                throw new EmitterException(ErrorCode.INCLUDE_NOT_FOUND, urlString, e.getMessage());
            }
        }
        throw new EmitterException(ErrorCode.INCLUDE_NOT_FOUND, fileName);
    }

    class JetTextTree
    extends JetTree {
        public JetTextTree(Token payload) {
            super(payload);
        }

        public void createElement() {
            TemplateElement element;
            String text = this.getText().replace("\r\n", "\n");
            boolean addNewElement = true;
            if (TemplateParser.this.elements.size() > 0 && (element = TemplateParser.this.elements.get(TemplateParser.this.elements.size() - 1)) instanceof TextElement) {
                TextElement textElement = (TextElement)element;
                textElement.getContent().append(text);
                addNewElement = false;
            }
            if (addNewElement) {
                TemplateParser.this.elements.add(new TextElement(text));
            }
        }
    }

    class JetScripletTree
    extends JetTree {
        public JetScripletTree(Token payload) {
            super(payload);
        }

        public void createElement() {
            TemplateParser.this.elements.add(new ScripletElement(this.getText()));
        }
    }

    class JetExpressionTree
    extends JetTree {
        public JetExpressionTree(Token payload) {
            super(payload);
        }

        public void createElement() {
            TemplateParser.this.elements.add(new ExpressionElement(this.getText()));
        }
    }

    class JetAttributeTree
    extends JetTree {
        public JetAttributeTree(Token payload) {
            super(payload);
        }

        public String getName() {
            return this.getChild(0).getText();
        }

        public String getValue() {
            return this.getChild(1).getText();
        }
    }

    class JetAttributesTree
    extends JetTree {
        public JetAttributesTree(Token payload) {
            super(payload);
        }

        public JetAttributeTree getAttribute(String name) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                JetAttributeTree attribute = (JetAttributeTree)this.getChild(i);
                if (!attribute.getName().equals(name)) continue;
                return attribute;
            }
            return null;
        }
    }

    class JetGenericIdTree
    extends JetTree {
        public JetGenericIdTree(Token payload) {
            super(payload);
        }
    }

    class JetDirectiveTree
    extends JetTree {
        public JetDirectiveTree(Token payload) {
            super(payload);
        }

        public String getId() {
            JetTree id = this.getChildByType(12);
            return id == null ? null : id.getText();
        }

        public String getAttribute(String name) {
            JetAttributeTree attrubute;
            JetAttributesTree attrubutes = (JetAttributesTree)this.getChildByType(9);
            if (attrubutes != null && (attrubute = attrubutes.getAttribute(name)) != null) {
                return attrubute.getValue();
            }
            return null;
        }
    }

    class JetTree
    extends CommonTree {
        public JetTree(Token payload) {
            super(payload);
        }

        public JetTree getChildByType(int type) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                JetTree tree = (JetTree)this.getChild(i);
                if (tree.getType() != type) continue;
                return tree;
            }
            return null;
        }

        public void createElement() {
        }
    }

    final class Adaptor
    extends CommonTreeAdaptor {
        private Adaptor() {
        }

        public Object create(Token payload) {
            if (payload == null) {
                return new JetTree(payload);
            }
            switch (payload.getType()) {
                case 12: {
                    return new JetGenericIdTree(payload);
                }
                case 9: {
                    return new JetAttributesTree(payload);
                }
                case 8: {
                    return new JetAttributeTree(payload);
                }
                case 5: {
                    return new JetDirectiveTree(payload);
                }
                case 4: {
                    return new JetExpressionTree(payload);
                }
                case 7: {
                    return new JetScripletTree(payload);
                }
                case 10: {
                    return new JetTextTree(payload);
                }
            }
            return new JetTree(payload);
        }
    }
}

