/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.wsdl.parser;

import com.sun.xml.ws.model.Mode;
import com.sun.xml.ws.model.ParameterBinding;
import com.sun.xml.ws.wsdl.parser.Binding;
import com.sun.xml.ws.wsdl.parser.BindingOperation;
import com.sun.xml.ws.wsdl.parser.Message;
import com.sun.xml.ws.wsdl.parser.Part;
import com.sun.xml.ws.wsdl.parser.Port;
import com.sun.xml.ws.wsdl.parser.PortType;
import com.sun.xml.ws.wsdl.parser.PortTypeOperation;
import com.sun.xml.ws.wsdl.parser.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLDocument {
    protected Map<QName, Message> messages = new HashMap<QName, Message>();
    protected Map<QName, PortType> portTypes = new HashMap<QName, PortType>();
    protected Map<QName, Binding> bindings = new HashMap<QName, Binding>();
    protected Map<QName, Service> services = new LinkedHashMap<QName, Service>();

    public void addMessage(Message msg) {
        this.messages.put(msg.getName(), msg);
    }

    public Message getMessage(QName name) {
        return this.messages.get(name);
    }

    public void addPortType(PortType pt) {
        this.portTypes.put(pt.getName(), pt);
    }

    public PortType getPortType(QName name) {
        return this.portTypes.get(name);
    }

    public void addBinding(Binding binding) {
        this.bindings.put(binding.getName(), binding);
    }

    public Binding getBinding(QName name) {
        return this.bindings.get(name);
    }

    public void addService(Service svc) {
        this.services.put(svc.getName(), svc);
    }

    public Service getService(QName name) {
        return this.services.get(name);
    }

    public Map<QName, Service> getServices() {
        return this.services;
    }

    public QName getFirstServiceName() {
        if (this.services.isEmpty()) {
            return null;
        }
        return this.services.values().iterator().next().getName();
    }

    public QName getFirstPortName() {
        if (this.services.isEmpty()) {
            return null;
        }
        Service service = this.services.values().iterator().next();
        Iterator iter = service.keySet().iterator();
        QName port = iter.hasNext() ? (QName)iter.next() : null;
        return port;
    }

    private Port getFirstPort() {
        if (this.services.isEmpty()) {
            return null;
        }
        Service service = this.services.values().iterator().next();
        Collection coll = service.values();
        Port port = coll != null ? (coll.iterator().hasNext() ? (Port)coll.iterator().next() : null) : null;
        return port;
    }

    public String getBindingId() {
        Port port = this.getFirstPort();
        if (port == null) {
            return null;
        }
        Binding binding = this.bindings.get(port.getBindingName());
        if (binding == null) {
            return null;
        }
        return binding.getBindingId();
    }

    public String getBindingId(QName service, QName port) {
        Binding b;
        Port p;
        Service s = this.services.get(service);
        if (s != null && (p = (Port)s.get(port)) != null && (b = this.bindings.get(p.getBindingName())) != null) {
            return b.getBindingId();
        }
        return null;
    }

    public Binding getBinding(QName serviceName, QName portName) {
        Port port;
        Service service = this.services.get(serviceName);
        if (service != null && (port = (Port)service.get(portName)) != null) {
            QName bindingName = port.getBindingName();
            return this.bindings.get(bindingName);
        }
        return null;
    }

    public List<Binding> getBindings(Service service, String bindingId) {
        ArrayList<Binding> bs = new ArrayList<Binding>();
        Collection ports = service.values();
        if (ports.isEmpty()) {
            return bs;
        }
        for (Port port : ports) {
            Binding b = this.bindings.get(port.getName());
            if (b == null) {
                return bs;
            }
            if (!b.equals(bindingId)) continue;
            bs.add(b);
        }
        return bs;
    }

    public void finalizeBinding(Binding binding) {
        assert (binding == null);
        QName portTypeName = binding.getPortTypeName();
        if (portTypeName == null) {
            return;
        }
        PortType pt = this.portTypes.get(portTypeName);
        if (pt == null) {
            return;
        }
        for (String op : binding.keySet()) {
            Message outMsg;
            PortTypeOperation pto = (PortTypeOperation)pt.get(op);
            if (pto == null) {
                return;
            }
            QName inMsgName = pto.getInputMessage();
            if (inMsgName == null) continue;
            Message inMsg = this.messages.get(inMsgName);
            BindingOperation bo = (BindingOperation)binding.get(op);
            int bodyindex = 0;
            if (inMsg != null) {
                for (String name : inMsg) {
                    ParameterBinding pb = bo.getInputBinding(name);
                    if (!pb.isBody()) continue;
                    bo.addPart(new Part(name, pb, bodyindex++), Mode.IN);
                }
            }
            bodyindex = 0;
            QName outMsgName = pto.getOutputMessage();
            if (outMsgName == null || (outMsg = this.messages.get(outMsgName)) == null) continue;
            for (String name : outMsg) {
                ParameterBinding pb = bo.getOutputBinding(name);
                if (!pb.isBody()) continue;
                bo.addPart(new Part(name, pb, bodyindex++), Mode.OUT);
            }
        }
    }
}

