/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.servlet;

import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.binding.soap.SOAPBindingImpl;
import com.sun.xml.ws.modeler.RuntimeModeler;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.spi.runtime.Binding;
import com.sun.xml.ws.streaming.Attributes;
import com.sun.xml.ws.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.HandlerAnnotationInfo;
import com.sun.xml.ws.util.HandlerAnnotationProcessor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.soap.SOAPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeEndpointInfoParser {
    protected ClassLoader classLoader;
    public static final String NS_RUNTIME = "http://java.sun.com/xml/ns/jax-ws/ri/runtime";
    public static final QName QNAME_ENDPOINTS = new QName("http://java.sun.com/xml/ns/jax-ws/ri/runtime", "endpoints");
    public static final QName QNAME_ENDPOINT = new QName("http://java.sun.com/xml/ns/jax-ws/ri/runtime", "endpoint");
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_IMPLEMENTATION = "implementation";
    public static final String ATTR_WSDL = "wsdl";
    public static final String ATTR_SERVICE = "service";
    public static final String ATTR_PORT = "port";
    public static final String ATTR_URL_PATTERN = "url-pattern";
    public static final String ATTR_ENABLE_MTOM = "enable-mtom";
    public static final String ATTR_MTOM_THRESHOLD_VALUE = "mtom-threshold-value";
    public static final String ATTR_BINDING = "binding";
    public static final String ATTRVALUE_VERSION_1_0 = "2.0";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");

    public RuntimeEndpointInfoParser(ClassLoader cl) {
        this.classLoader = cl;
    }

    public List<RuntimeEndpointInfo> parse(InputStream is) {
        try {
            XMLStreamReader reader = XMLStreamReaderFactory.createXMLStreamReader(is, true);
            XMLStreamReaderUtil.nextElementContent(reader);
            return this.parseEndpoints(reader);
        }
        catch (XMLStreamException e) {
            throw new ServerRtException("runtime.parser.xmlReader", e);
        }
    }

    protected List<RuntimeEndpointInfo> parseEndpoints(XMLStreamReader reader) throws XMLStreamException {
        if (!reader.getName().equals(QNAME_ENDPOINTS)) {
            RuntimeEndpointInfoParser.failWithFullName("runtime.parser.invalidElement", reader);
        }
        ArrayList<RuntimeEndpointInfo> endpoints = new ArrayList<RuntimeEndpointInfo>();
        Attributes attrs = XMLStreamReaderUtil.getAttributes(reader);
        String version = this.getMandatoryNonEmptyAttribute(reader, attrs, ATTR_VERSION);
        if (!version.equals(ATTRVALUE_VERSION_1_0)) {
            RuntimeEndpointInfoParser.failWithLocalName("runtime.parser.invalidVersionNumber", reader, version);
        }
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            if (reader.getName().equals(QNAME_ENDPOINT)) {
                RuntimeEndpointInfo rei = new RuntimeEndpointInfo();
                attrs = XMLStreamReaderUtil.getAttributes(reader);
                rei.setName(this.getMandatoryNonEmptyAttribute(reader, attrs, ATTR_NAME));
                String implementationName = this.getMandatoryNonEmptyAttribute(reader, attrs, ATTR_IMPLEMENTATION);
                Class implementorClass = this.getImplementorClass(implementationName);
                rei.setImplementorClass(implementorClass);
                rei.setImplementor(this.getImplementor(implementorClass));
                String wsdlFile = this.getAttribute(attrs, ATTR_WSDL);
                if (wsdlFile != null) {
                    if (!wsdlFile.startsWith("WEB-INF/wsdl")) {
                        logger.warning("Ignoring wrong wsdl=" + wsdlFile + ". It should start with " + "WEB-INF/wsdl" + ". Going to generate and publish a new WSDL.");
                        wsdlFile = null;
                    }
                } else {
                    WebServiceProvider wsProvider = implementorClass.getAnnotation(WebServiceProvider.class);
                    if (wsProvider != null && !wsProvider.wsdlLocation().equals("")) {
                        wsdlFile = wsProvider.wsdlLocation();
                    }
                }
                rei.setWSDLFileName(wsdlFile);
                rei.setServiceName(this.getQNameAttribute(attrs, ATTR_SERVICE));
                rei.setPortName(this.getQNameAttribute(attrs, ATTR_PORT));
                String bindingId = this.getAttribute(attrs, ATTR_BINDING);
                Binding binding = BindingImpl.getBinding(bindingId, implementorClass, rei.getServiceName(), true);
                rei.setBinding(binding);
                String mtom = this.getAttribute(attrs, ATTR_ENABLE_MTOM);
                String mtomThreshold = this.getAttribute(attrs, ATTR_MTOM_THRESHOLD_VALUE);
                if (mtomThreshold != null) {
                    int mtomThresholdValue = Integer.valueOf(mtomThreshold);
                    rei.setMtomThreshold(mtomThresholdValue);
                }
                if (rei.getBinding() instanceof SOAPBindingImpl) {
                    SOAPBinding sb = (SOAPBinding)rei.getBinding();
                    sb.setMTOMEnabled(mtom != null ? Boolean.valueOf(mtom) : false);
                }
                rei.setUrlPattern(this.getMandatoryNonEmptyAttribute(reader, attrs, ATTR_URL_PATTERN));
                this.setHandlersAndRoles(rei, reader);
                RuntimeEndpointInfoParser.ensureNoContent(reader);
                endpoints.add(rei);
                continue;
            }
            RuntimeEndpointInfoParser.failWithLocalName("runtime.parser.invalidElement", reader);
        }
        reader.close();
        return endpoints;
    }

    protected String getAttribute(Attributes attrs, String name) {
        String value = attrs.getValue(name);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    protected QName getQNameAttribute(Attributes attrs, String name) {
        String value = this.getAttribute(attrs, name);
        if (value == null || value.equals("")) {
            return null;
        }
        return QName.valueOf(value);
    }

    protected String getNonEmptyAttribute(XMLStreamReader reader, Attributes attrs, String name) {
        String value = this.getAttribute(attrs, name);
        if (value != null && value.equals("")) {
            RuntimeEndpointInfoParser.failWithLocalName("runtime.parser.invalidAttributeValue", reader, name);
        }
        return value;
    }

    protected String getMandatoryAttribute(XMLStreamReader reader, Attributes attrs, String name) {
        String value = this.getAttribute(attrs, name);
        if (value == null) {
            RuntimeEndpointInfoParser.failWithLocalName("runtime.parser.missing.attribute", reader, name);
        }
        return value;
    }

    protected String getMandatoryNonEmptyAttribute(XMLStreamReader reader, Attributes attributes, String name) {
        String value = this.getAttribute(attributes, name);
        if (value == null) {
            RuntimeEndpointInfoParser.failWithLocalName("runtime.parser.missing.attribute", reader, name);
        } else if (value.equals("")) {
            RuntimeEndpointInfoParser.failWithLocalName("runtime.parser.invalidAttributeValue", reader, name);
        }
        return value;
    }

    protected void setHandlersAndRoles(RuntimeEndpointInfo rei, XMLStreamReader reader) {
        if (XMLStreamReaderUtil.nextElementContent(reader) == 2 || !reader.getName().equals(HandlerAnnotationProcessor.QNAME_HANDLER_CHAINS)) {
            return;
        }
        QName serviceName = rei.getServiceName();
        if (serviceName == null) {
            serviceName = RuntimeModeler.getServiceName(rei.getImplementorClass());
        }
        HandlerAnnotationInfo handlerInfo = HandlerAnnotationProcessor.parseHandlerFile(reader, this.classLoader, serviceName, rei.getPortName(), ((BindingImpl)rei.getBinding()).getBindingId());
        rei.getBinding().setHandlerChain(handlerInfo.getHandlers());
        if (rei.getBinding() instanceof SOAPBinding) {
            ((SOAPBinding)rei.getBinding()).setRoles(handlerInfo.getRoles());
        }
        XMLStreamReaderUtil.nextContent(reader);
    }

    protected static void ensureNoContent(XMLStreamReader reader) {
        if (reader.getEventType() != 2) {
            RuntimeEndpointInfoParser.fail("runtime.parser.unexpectedContent", reader);
        }
    }

    protected static void fail(String key, XMLStreamReader reader) {
        logger.log(Level.SEVERE, key + reader.getLocation().getLineNumber());
        throw new ServerRtException(key, Integer.toString(reader.getLocation().getLineNumber()));
    }

    protected static void failWithFullName(String key, XMLStreamReader reader) {
        throw new ServerRtException(key, Integer.toString(reader.getLocation().getLineNumber()), reader.getName().toString());
    }

    protected static void failWithLocalName(String key, XMLStreamReader reader) {
        throw new ServerRtException(key, Integer.toString(reader.getLocation().getLineNumber()), reader.getLocalName());
    }

    protected static void failWithLocalName(String key, XMLStreamReader reader, String arg) {
        throw new ServerRtException(key, Integer.toString(reader.getLocation().getLineNumber()), reader.getLocalName(), arg);
    }

    protected Class loadClass(String name) {
        try {
            return Class.forName(name, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new ServerRtException("runtime.parser.classNotFound", name);
        }
    }

    protected Class getImplementorClass(String name) {
        try {
            return Class.forName(name, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new ServerRtException("runtime.parser.classNotFound", name);
        }
    }

    protected Object getImplementor(Class cl) {
        try {
            return cl.newInstance();
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new ServerRtException("error.implementorFactory.newInstanceFailed", cl.getName());
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new ServerRtException("error.implementorFactory.newInstanceFailed", cl.getName());
        }
    }
}

