/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.binding.soap;

import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.handler.HandlerChainCaller;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegateFactory;
import com.sun.xml.ws.util.SOAPUtil;
import com.sun.xml.ws.util.localization.Localizable;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.ws.util.localization.Localizer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPBindingImpl
extends BindingImpl
implements SOAPBinding {
    public static final String X_SOAP12HTTP_BINDING = "http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/";
    protected static String ROLE_NONE;
    protected Set<String> requiredRoles;
    protected Set<String> roles;
    protected boolean enableMtom = false;

    public SOAPBindingImpl(String bindingId, QName serviceName) {
        super(bindingId, serviceName);
        this.setup(this.getBindingId());
        this.setupSystemHandlerDelegate(serviceName);
    }

    public SOAPBindingImpl(String bindingId) {
        super(bindingId, null);
        this.setup(this.getBindingId());
        this.setupSystemHandlerDelegate(null);
    }

    public SOAPBindingImpl(List<Handler> handlerChain, String bindingId, QName serviceName) {
        super(handlerChain, bindingId, serviceName);
        this.setup(this.getBindingId());
        this.setupSystemHandlerDelegate(serviceName);
    }

    protected void setup(String bindingId) {
        this.requiredRoles = new HashSet<String>();
        if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
            this.requiredRoles.add("http://schemas.xmlsoap.org/soap/actor/next");
        } else if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            this.requiredRoles.add("http://www.w3.org/2003/05/soap-envelope/role/next");
            this.requiredRoles.add("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        }
        ROLE_NONE = "http://www.w3.org/2003/05/soap-envelope/role/none";
        this.roles = new HashSet<String>();
        this.addRequiredRoles();
        this.setRolesOnHandlerChain();
    }

    @Override
    public String getBindingId() {
        String bindingId = super.getBindingId();
        if (bindingId.equals(X_SOAP12HTTP_BINDING)) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        return bindingId;
    }

    @Override
    public String getActualBindingId() {
        return super.getBindingId();
    }

    @Override
    public void setHandlerChain(List<Handler> chain) {
        super.setHandlerChain(chain);
        this.setRolesOnHandlerChain();
    }

    protected void addRequiredRoles() {
        this.roles.addAll(this.requiredRoles);
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        if (roles == null) {
            roles = new HashSet<String>();
        }
        if (roles.contains(ROLE_NONE)) {
            LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.xml.ws.resources.client");
            Localizer localizer = new Localizer();
            Localizable locMessage = messageFactory.getMessage("invalid.soap.role.none", new Object[0]);
            throw new WebServiceException(localizer.localize(locMessage));
        }
        this.roles = roles;
        this.addRequiredRoles();
        this.setRolesOnHandlerChain();
    }

    public boolean isMTOMEnabled() {
        return this.enableMtom;
    }

    public void setMTOMEnabled(boolean b) {
        this.enableMtom = b;
    }

    public SOAPFactory getSOAPFactory() {
        return SOAPUtil.getSOAPFactory(this.getBindingId());
    }

    public MessageFactory getMessageFactory() {
        return SOAPUtil.getMessageFactory(this.getBindingId());
    }

    @Override
    public HandlerChainCaller getHandlerChainCaller() {
        HandlerChainCaller caller = super.getHandlerChainCaller();
        caller.setRoles(this.roles);
        return this.chainCaller;
    }

    protected void setRolesOnHandlerChain() {
        if (this.chainCaller != null) {
            this.chainCaller.setRoles(this.roles);
        }
    }

    protected void setupSystemHandlerDelegate(QName serviceName) {
        SystemHandlerDelegateFactory shdFactory = SystemHandlerDelegateFactory.getFactory();
        if (shdFactory != null) {
            this.setSystemHandlerDelegate(shdFactory.getDelegate(serviceName));
        }
    }
}

