/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.ClassLoaderUtil;
import com.sun.grizzly.util.ExpandJar;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;

public abstract class StandaloneMainUtil {
    public static final String SELECTOR_THREAD = "com.sun.grizzly.selectorThread";
    public static final String ADAPTER = "com.sun.grizzly.adapterClass";
    private int port = 8080;
    private InetAddress address;
    private long t1 = 0L;

    public StandaloneMainUtil() {
        try {
            this.address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            throw new IllegalStateException(uhe);
        }
    }

    public void start(String[] args) throws Exception {
        SelectorThread st = this.createSelectorThread(args);
        this.startSelectorThread(st);
    }

    public void stop() throws Exception {
        SelectorThread.getSelector(this.address, this.port).stopEndpoint();
    }

    public SelectorThread createSelectorThread(String[] args) throws Exception {
        if (args.length == 0) {
            this.printHelpAndExit();
        }
        this.t1 = System.currentTimeMillis();
        this.parseOptions(args);
        String appliPath = this.parseApplicationLocation(args);
        appliPath = this.appendWarContentToClassPath(appliPath);
        String selectorThreadClassname = System.getProperty(SELECTOR_THREAD);
        SelectorThread st = selectorThreadClassname != null ? (SelectorThread)ClassLoaderUtil.load((String)selectorThreadClassname) : new SelectorThread(){

            public void listen() throws InstantiationException, IOException {
                super.listen();
                logger.info("Server started in " + (System.currentTimeMillis() - StandaloneMainUtil.this.t1) + " milliseconds.");
            }
        };
        st.setAlgorithmClassName(StaticStreamAlgorithm.class.getName());
        st.setPort(this.port);
        st.setWebAppRootPath(appliPath);
        st.setAdapter(this.configureAdapter(st));
        return st;
    }

    public String appendWarContentToClassPath(String appliPath) throws IOException {
        URL[] urls;
        String separator;
        String path;
        URL classesURL;
        URL appRoot;
        if (appliPath != null && (appliPath.endsWith(".war") || appliPath.endsWith(".jar"))) {
            File file = new File(appliPath);
            appRoot = new URL("jar:file:" + file.getCanonicalPath() + "!/");
            classesURL = new URL("jar:file:" + file.getCanonicalPath() + "!/WEB-INF/classes/");
            path = ExpandJar.expand((URL)appRoot);
        } else {
            path = appliPath;
            classesURL = new URL("file://" + path + "WEB-INF/classes/");
            appRoot = new URL("file://" + path);
        }
        String absolutePath = new File(path).getAbsolutePath();
        SelectorThread.logger().info("Servicing resources from: " + absolutePath);
        File libFiles = new File(absolutePath + File.separator + "WEB-INF" + File.separator + "lib");
        int arraySize = appRoot == null ? 1 : 2;
        String string = separator = System.getProperty("os.name").toLowerCase().startsWith("win") ? "/" : "//";
        if (libFiles.exists() && libFiles.isDirectory()) {
            urls = new URL[libFiles.listFiles().length + arraySize];
            for (int i = 0; i < libFiles.listFiles().length; ++i) {
                urls[i] = new URL("jar:file:" + separator + libFiles.listFiles()[i].toString().replace('\\', '/') + "!/");
            }
        } else {
            urls = new URL[arraySize];
        }
        urls[urls.length - 1] = classesURL;
        urls[urls.length - 2] = appRoot;
        URLClassLoader urlClassloader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(urlClassloader);
        return path;
    }

    public void startSelectorThread(SelectorThread st) throws IOException, InstantiationException {
        st.setDisplayConfiguration(true);
        st.listen();
    }

    public void setPort(String num) {
        try {
            this.port = Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            System.err.println("Illegal port number -- " + num);
            this.printHelpAndExit();
        }
    }

    public abstract void printHelpAndExit();

    public abstract boolean parseOptions(String[] var1);

    public abstract Adapter configureAdapter(SelectorThread var1);

    public abstract String parseApplicationLocation(String[] var1);
}

