/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.arp;

import com.sun.grizzly.Context;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.http.DefaultProtocolFilter;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.TaskEvent;
import com.sun.grizzly.http.TaskListener;
import com.sun.grizzly.http.algorithms.NoParsingAlgorithm;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.DataStructures;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.Interceptor;
import com.sun.grizzly.util.SelectionKeyAttachment;
import com.sun.grizzly.util.StreamAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncProtocolFilter
extends DefaultProtocolFilter
implements TaskListener {
    private final Queue<InputReader> byteBufferStreams = DataStructures.getCLQinstance(InputReader.class);
    protected int bbSize = 4096;
    protected Interceptor<ByteBuffer, SocketChannel> interceptor;

    @Deprecated
    public AsyncProtocolFilter(Class algorithmClass, int port) {
        super(algorithmClass, null, port);
    }

    public AsyncProtocolFilter(Class algorithmClass, InetAddress address, int port) {
        super(algorithmClass, address, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(Context ctx) throws IOException {
        SelectorThread selectorThread = SelectorThread.getSelector(this.address, this.port);
        SelectionKey key = ctx.getSelectionKey();
        if (Boolean.TRUE.equals(ctx.getAttribute("delayedClose"))) {
            if (selectorThread.isAsyncHttpWriteEnabled()) {
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
                AsyncProtocolFilter.flushAsyncWriteQueueAndClose(ctx.getSelectorHandler(), key);
            } else {
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
            }
            return false;
        }
        HttpWorkerThread workerThread = (HttpWorkerThread)((Object)Thread.currentThread());
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        if (this.interceptor != null && this.interceptor.handle((Object)byteBuffer, 2) == 1) {
            return super.execute(ctx);
        }
        StreamAlgorithm streamAlgorithm = workerThread.getStreamAlgorithm();
        if (streamAlgorithm == null) {
            try {
                streamAlgorithm = (StreamAlgorithm)this.algorithmClass.newInstance();
            }
            catch (InstantiationException ex) {
                logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClass.getName());
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClass.getName());
            }
            finally {
                if (streamAlgorithm == null) {
                    streamAlgorithm = new NoParsingAlgorithm();
                }
            }
            streamAlgorithm.setPort(this.port);
        } else {
            workerThread.setStreamAlgorithm(null);
        }
        this.bbSize = selectorThread.getMaxHttpHeaderSize();
        InputReader inputStream = this.byteBufferStreams.poll();
        if (inputStream == null) {
            inputStream = this.createInputReader();
        }
        this.configureInputBuffer(inputStream, ctx, workerThread);
        SocketChannel socketChannel = (SocketChannel)key.channel();
        streamAlgorithm.setChannel((Object)socketChannel);
        ByteBuffer nextBuffer = inputStream.getByteBuffer();
        nextBuffer.clear();
        workerThread.setByteBuffer(nextBuffer);
        inputStream.setByteBuffer(byteBuffer);
        byteBuffer = streamAlgorithm.preParse(byteBuffer);
        ctx.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
        if (streamAlgorithm.parse(byteBuffer)) {
            ProcessorTask processor = selectorThread.getProcessorTask();
            this.configureProcessorTask(processor, ctx, streamAlgorithm, (InputStream)inputStream);
            try {
                selectorThread.getAsyncHandler().handle(processor);
            }
            catch (Throwable ex) {
                logger.log(Level.INFO, "Processor exception", ex);
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskEvent(TaskEvent event) {
        if (event.getStatus() == 2 || event.getStatus() == 1) {
            ProcessorTask processor = (ProcessorTask)event.attachement();
            SelectionKey processorSelectionKey = processor.getSelectionKey();
            if (processorSelectionKey == null) {
                logger.log(Level.WARNING, "AsyncProtocolFilter invalid state.");
                return;
            }
            InputReader is = (InputReader)processor.getInputStream();
            is.getByteBuffer().clear();
            this.byteBufferStreams.offer(is);
            SelectorThread selectorThread = processor.getSelectorThread();
            SelectorHandler selectorHandler = processor.getSelectorHandler();
            boolean cancelkey = processor.getAptCancelKey() || processor.isError() || !processor.isKeepAlive();
            try {
                if (!cancelkey) {
                    if (processor.getReRegisterSelectionKey()) {
                        this.setSelectionKeyTimeout(processorSelectionKey, Long.MIN_VALUE);
                        selectorHandler.register(processorSelectionKey, 1);
                    }
                } else if (selectorThread.isAsyncHttpWriteEnabled()) {
                    AsyncProtocolFilter.flushAsyncWriteQueueAndClose(selectorHandler, processorSelectionKey);
                } else {
                    selectorHandler.getSelectionKeyHandler().cancel(processorSelectionKey);
                }
            }
            finally {
                processor.recycle();
                selectorThread.returnTask(processor);
            }
        }
    }

    protected void configureProcessorTask(ProcessorTask processorTask, Context context, StreamAlgorithm streamAlgorithm, InputStream inputStream) {
        SelectionKey key = context.getSelectionKey();
        processorTask.setSelectionKey(key);
        processorTask.setSelectorHandler(context.getSelectorHandler());
        processorTask.setSocket(((SocketChannel)key.channel()).socket());
        processorTask.setTaskListener(this);
        processorTask.setInputStream(inputStream);
        processorTask.setStreamAlgorithm(streamAlgorithm);
    }

    @Override
    protected void configureInputBuffer(InputReader inputStream, Context context, HttpWorkerThread workerThread) {
        ByteBuffer associatedBuffer = inputStream.getByteBuffer();
        inputStream.recycle();
        inputStream.setByteBuffer(associatedBuffer);
        inputStream.setSelectionKey(context.getSelectionKey());
        inputStream.setSecure(this.isSecure());
    }

    protected InputReader createInputReader() {
        return new InputReader(ByteBufferFactory.allocateView((int)this.bbSize, (boolean)false));
    }

    private void setSelectionKeyTimeout(SelectionKey selectionKey, long timeout) {
        Object attachment = selectionKey.attachment();
        if (attachment == null) {
            selectionKey.attach(timeout);
        } else if (attachment instanceof SelectionKeyAttachment) {
            ((SelectionKeyAttachment)attachment).setTimeout(timeout);
        }
    }

    public Interceptor<ByteBuffer, SocketChannel> getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(Interceptor<ByteBuffer, SocketChannel> interceptor) {
        this.interceptor = interceptor;
    }
}

