/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.sagacity.sqltoy.callback.XMLCallbackHandler;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.FileUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLUtil {
    private static final Logger logger = LoggerFactory.getLogger(XMLUtil.class);
    private static final String NO_VALIDATOR_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    private XMLUtil() {
    }

    public static Object readXML(Object xmlFile, String charset, boolean isValidator, XMLCallbackHandler handler) throws Exception {
        if (StringUtil.isBlank(xmlFile)) {
            return null;
        }
        try (InputStream fileIS = null;){
            Document doc;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (!isValidator) {
                factory.setFeature(NO_VALIDATOR_FEATURE, false);
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            fileIS = FileUtil.getFileInputStream(xmlFile);
            if (fileIS != null && null != (doc = builder.parse(fileIS))) {
                Object object = handler.process(doc, doc.getDocumentElement());
                return object;
            }
        }
        return null;
    }

    private static IgnoreKeyCaseMap<String, String> asMap(String ... keyValues) {
        IgnoreKeyCaseMap<String, String> result = new IgnoreKeyCaseMap<String, String>();
        if (keyValues == null || keyValues.length == 0) {
            return result;
        }
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            result.put(keyValues[i], keyValues[i + 1]);
        }
        return result;
    }

    public static void setAttributes(Element elt, Serializable entity, String ... aliasProps) throws Exception {
        String name;
        if (elt == null) {
            return;
        }
        IgnoreKeyCaseMap<String, String> realMap = XMLUtil.asMap(aliasProps);
        NamedNodeMap attrs = elt.getAttributes();
        String[] properties = new String[attrs.getLength() + 1];
        String[] values = new String[attrs.getLength() + 1];
        int index = 0;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            name = attr.getNodeName();
            String value = attr.getNodeValue();
            properties[index] = realMap.containsKey(name) ? realMap.get(name) : StringUtil.toHumpStr(name, false);
            values[index] = value;
            ++index;
        }
        name = elt.getNodeName();
        properties[index] = realMap.containsKey(name) ? realMap.get(name) : StringUtil.toHumpStr(name, false);
        values[index] = StringUtil.trim(elt.getTextContent());
        Method[] realMethods = BeanUtil.matchSetMethods(entity.getClass(), properties);
        for (int i = 0; i < properties.length; ++i) {
            Method method;
            if (!StringUtil.isNotBlank(values[i]) || (method = realMethods[i]) == null) continue;
            try {
                Class<?> argType = method.getParameterTypes()[0];
                String className = argType.getTypeName().toLowerCase();
                className = className.substring(className.lastIndexOf(".") + 1);
                if (argType.isArray()) {
                    int j;
                    Object[] arrayData;
                    String[] args = values[i].replaceAll("\\\uff0c", ",").split("\\,");
                    if ("int".equals(className = className.substring(0, className.indexOf("[")))) {
                        arrayData = new int[args.length];
                        for (j = 0; j < arrayData.length; ++j) {
                            arrayData[j] = Integer.parseInt(args[j]);
                        }
                        method.invoke((Object)entity, new Object[]{arrayData});
                        continue;
                    }
                    if ("long".equals(className)) {
                        arrayData = new long[args.length];
                        for (j = 0; j < arrayData.length; ++j) {
                            arrayData[j] = (int)Long.parseLong(args[j]);
                        }
                        method.invoke((Object)entity, new Object[]{arrayData});
                        continue;
                    }
                    if ("float".equals(className)) {
                        arrayData = new float[args.length];
                        for (j = 0; j < arrayData.length; ++j) {
                            arrayData[j] = (int)Float.parseFloat(args[j]);
                        }
                        method.invoke((Object)entity, new Object[]{arrayData});
                        continue;
                    }
                    if ("double".equals(className)) {
                        arrayData = new double[args.length];
                        for (j = 0; j < arrayData.length; ++j) {
                            arrayData[j] = (int)Double.parseDouble(args[j]);
                        }
                        method.invoke((Object)entity, new Object[]{arrayData});
                        continue;
                    }
                    if ("short".equals(className)) {
                        arrayData = new short[args.length];
                        for (j = 0; j < arrayData.length; ++j) {
                            arrayData[j] = Short.parseShort(args[j]);
                        }
                        method.invoke((Object)entity, new Object[]{arrayData});
                        continue;
                    }
                    if ("boolean".equals(className)) {
                        arrayData = new boolean[args.length];
                        for (j = 0; j < arrayData.length; ++j) {
                            arrayData[j] = Boolean.parseBoolean(args[j]) ? 1 : 0;
                        }
                        method.invoke((Object)entity, new Object[]{arrayData});
                        continue;
                    }
                    Object[] valueAry = CollectionUtil.toArray(args, className);
                    method.invoke((Object)entity, new Object[]{valueAry});
                    continue;
                }
                if (!BeanUtil.isBaseDataType(argType)) continue;
                method.invoke((Object)entity, XMLUtil.convertType(values[i], className));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public static Object convertType(String value, String lowCaseTypeName) {
        boolean isBlank;
        if ("java.lang.string".equals(lowCaseTypeName) || "string".equals(lowCaseTypeName)) {
            return value;
        }
        boolean bl = isBlank = value != null && "".equals(value.trim());
        if (value == null || isBlank) {
            if ("int".equals(lowCaseTypeName) || "long".equals(lowCaseTypeName) || "double".equals(lowCaseTypeName) || "float".equals(lowCaseTypeName) || "short".equals(lowCaseTypeName)) {
                return 0;
            }
            if ("boolean".equals(lowCaseTypeName)) {
                return false;
            }
            if ("char".equals(lowCaseTypeName) && isBlank) {
                return Character.valueOf(" ".charAt(0));
            }
            return null;
        }
        if ("java.math.bigdecimal".equals(lowCaseTypeName) || "decimal".equals(lowCaseTypeName) || "bigdecimal".equals(lowCaseTypeName)) {
            return new BigDecimal(BeanUtil.convertBoolean(value));
        }
        if ("java.time.localdatetime".equals(lowCaseTypeName) || "localdatetime".equals(lowCaseTypeName)) {
            return DateUtil.asLocalDateTime(DateUtil.convertDateObject(value));
        }
        if ("java.time.localdate".equals(lowCaseTypeName) || "localdate".equals(lowCaseTypeName)) {
            return DateUtil.asLocalDate(DateUtil.convertDateObject(value));
        }
        if ("java.lang.integer".equals(lowCaseTypeName) || "integer".equals(lowCaseTypeName)) {
            return Integer.valueOf(BeanUtil.convertBoolean(value).split("\\.")[0]);
        }
        if ("java.sql.timestamp".equals(lowCaseTypeName) || "timestamp".equals(lowCaseTypeName)) {
            return new Timestamp(DateUtil.parseString(value).getTime());
        }
        if ("java.lang.double".equals(lowCaseTypeName)) {
            return Double.valueOf(value);
        }
        if ("java.util.date".equals(lowCaseTypeName) || "date".equals(lowCaseTypeName)) {
            return DateUtil.parseString(value);
        }
        if ("java.lang.long".equals(lowCaseTypeName)) {
            return Long.valueOf(BeanUtil.convertBoolean(value).split("\\.")[0]);
        }
        if ("int".equals(lowCaseTypeName)) {
            return Double.valueOf(BeanUtil.convertBoolean(value)).intValue();
        }
        if ("java.time.localtime".equals(lowCaseTypeName) || "localtime".equals(lowCaseTypeName)) {
            return DateUtil.asLocalTime(DateUtil.convertDateObject(value));
        }
        if ("java.math.biginteger".equals(lowCaseTypeName) || "biginteger".equals(lowCaseTypeName)) {
            return new BigInteger(BeanUtil.convertBoolean(value).split("\\.")[0]);
        }
        if ("long".equals(lowCaseTypeName)) {
            return Double.valueOf(BeanUtil.convertBoolean(value)).longValue();
        }
        if ("double".equals(lowCaseTypeName)) {
            return (double)Double.valueOf(value);
        }
        if ("boolean".equals(lowCaseTypeName)) {
            if ("true".equals(value.toLowerCase()) || "1".equals(value)) {
                return true;
            }
            return false;
        }
        if ("java.lang.boolean".equals(lowCaseTypeName)) {
            if ("true".equals(value.toLowerCase()) || "1".equals(value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if ("java.lang.short".equals(lowCaseTypeName)) {
            return Double.valueOf(BeanUtil.convertBoolean(value)).shortValue();
        }
        if ("short".equals(lowCaseTypeName)) {
            return Double.valueOf(BeanUtil.convertBoolean(value)).shortValue();
        }
        if ("java.lang.float".equals(lowCaseTypeName)) {
            return Float.valueOf(value);
        }
        if ("float".equals(lowCaseTypeName)) {
            return Float.valueOf(Float.valueOf(value).floatValue());
        }
        if ("java.sql.date".equals(lowCaseTypeName)) {
            return new Date(DateUtil.parseString(value).getTime());
        }
        if ("char".equals(lowCaseTypeName)) {
            return Character.valueOf(value.charAt(0));
        }
        if ("java.sql.time".equals(lowCaseTypeName) || "time".equals(lowCaseTypeName)) {
            return DateUtil.parseString(value);
        }
        return value;
    }
}

