/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.sharding.impl;

import java.util.HashMap;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.ShardingDBModel;
import org.sagacity.sqltoy.model.IgnoreCaseLinkedMap;
import org.sagacity.sqltoy.plugins.sharding.ShardingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashShardingStrategy
implements ShardingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(HashShardingStrategy.class);
    private HashMap<String, String> dataSourceMap = new HashMap();
    private HashMap<String, String> tableMap = new HashMap();
    private int dataSourceMode;
    private int tableMode;

    @Override
    public String getShardingTable(SqlToyContext sqlToyContext, Class entityClass, String baseTableName, String decisionType, IgnoreCaseLinkedMap<String, Object> paramsMap) {
        if (this.tableMode < 1 || paramsMap == null || paramsMap.isEmpty()) {
            return null;
        }
        Object shardingValue = paramsMap.values().iterator().next();
        int hashCode = shardingValue.hashCode();
        String modeKey = Integer.toString(hashCode % this.tableMode);
        logger.debug("\u5206\u8868\u53d6\u5f97modeKey:{},tableName:{}", (Object)modeKey, (Object)this.tableMap.get(modeKey));
        return this.tableMap.get(modeKey);
    }

    @Override
    public ShardingDBModel getShardingDB(SqlToyContext sqlToyContext, Class entityClass, String tableOrSql, String strategyVar, IgnoreCaseLinkedMap<String, Object> paramsMap) {
        ShardingDBModel shardingModel = new ShardingDBModel();
        if (this.dataSourceMode < 1 || paramsMap == null || paramsMap.isEmpty()) {
            return shardingModel;
        }
        Object shardingValue = paramsMap.values().iterator().next();
        int hashCode = shardingValue.hashCode();
        String modeKey = Integer.toString(hashCode % this.dataSourceMode);
        shardingModel.setDataSourceName(this.dataSourceMap.get(modeKey));
        logger.debug("\u5206\u5e93\u53d6\u5f97modeKey:{},dataSourceName:{}", (Object)modeKey, (Object)shardingModel.getDataSourceName());
        return shardingModel;
    }

    @Override
    public void initialize() {
        if (this.dataSourceMode == 0) {
            this.dataSourceMode = this.dataSourceMap.size();
        }
        if (this.tableMode == 0) {
            this.tableMode = this.tableMap.size();
        }
    }

    public HashMap<String, String> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public void setDataSourceMap(HashMap<String, String> dataSourceMap) {
        this.dataSourceMap = dataSourceMap;
    }

    public HashMap<String, String> getTableMap() {
        return this.tableMap;
    }

    public void setTableMap(HashMap<String, String> tableMap) {
        this.tableMap = tableMap;
    }
}

