/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.sharding;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.sagacity.sqltoy.integration.AppContext;
import org.sagacity.sqltoy.integration.ConnectionFactory;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleConnectionMonitor
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(IdleConnectionMonitor.class);
    private Object[][] dataSourceWeightConfig;
    private AppContext appContext;
    private int[] weights;
    private Integer delaySeconds;
    private Integer intervalSeconds;
    private ConnectionFactory connectionFactory;

    public IdleConnectionMonitor(AppContext appContext, ConnectionFactory connectionFactory, Object[][] dataSourceWeightConfig, int[] weights, Integer delaySeconds, Integer intervalSeconds) {
        this.appContext = appContext;
        this.connectionFactory = connectionFactory;
        this.dataSourceWeightConfig = dataSourceWeightConfig;
        this.weights = weights;
        this.delaySeconds = delaySeconds;
        this.intervalSeconds = intervalSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            if (this.delaySeconds >= 1) {
                Thread.sleep(1000 * this.delaySeconds);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean isRun = true;
        DataSource dataSource = null;
        Connection conn = null;
        Statement pst = null;
        ResultSet rs = null;
        while (isRun) {
            int i = 0;
            Object[][] objectArray = this.dataSourceWeightConfig;
            int n = objectArray.length;
            for (int j = 0; j < n; ++i, ++j) {
                block31: {
                    Object[] dataBase = objectArray[j];
                    try {
                        dataSource = (DataSource)this.appContext.getBean(dataBase[0].toString());
                        if ((Integer)dataBase[1] > 0 && null != dataSource) {
                            conn = this.connectionFactory.getConnection(dataSource);
                            pst = conn.prepareStatement(DataSourceUtils.getValidateQuery(conn));
                            rs = pst.executeQuery();
                            this.weights[i] = (Integer)dataBase[1];
                        } else {
                            this.weights[i] = 0;
                        }
                        if (rs != null) {
                        }
                        break block31;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.weights[i] = 0;
                        continue;
                    }
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (pst != null) {
                    try {
                        pst.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (dataSource == null) continue;
                this.connectionFactory.releaseConnection(conn, dataSource);
                continue;
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (pst != null) {
                        try {
                            pst.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (dataSource != null) {
                        this.connectionFactory.releaseConnection(conn, dataSource);
                    }
                }
            }
            try {
                Thread.sleep(1000 * this.intervalSeconds);
            }
            catch (InterruptedException e) {
                this.logger.warn("datasource sharding \u53ef\u7528\u6027\u68c0\u6d4b\u76d1\u6d4b\u5c06\u7ec8\u6b62!{}", (Object)e.getMessage(), (Object)e);
                isRun = false;
            }
        }
    }
}

