/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.id.macro;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.plugins.id.macro.AbstractMacro;
import org.sagacity.sqltoy.plugins.id.macro.impl.Case;
import org.sagacity.sqltoy.plugins.id.macro.impl.DateFormat;
import org.sagacity.sqltoy.plugins.id.macro.impl.SubString;
import org.sagacity.sqltoy.utils.StringUtil;

public class MacroUtils {
    private static Pattern macroPattern = Pattern.compile("@[a-zA-Z]+[0-9]*[\\-]?[a-zA-Z]*\\([\\w\\W]*\\)");
    private static final Pattern paramPattern = Pattern.compile("(\\$|\\#)\\{\\s*\\_?[0-9a-zA-Z\u4e00-\u9fa5]+((\\.|\\_)[0-9a-zA-Z\u4e00-\u9fa5]+)*(\\[\\d*(\\,)?\\d*\\])?\\s*\\}");
    private static final HashMap<String, String> filters = new HashMap<String, String>(){
        private static final long serialVersionUID = 2445408357544337801L;
        {
            this.put("(", ")");
            this.put("'", "'");
            this.put("\"", "\"");
            this.put("[", "]");
            this.put("{", "}");
        }
    };
    private static Map<String, AbstractMacro> macros = new HashMap<String, AbstractMacro>();

    public static String replaceMacros(String hasMacroStr, Map<String, Object> keyValues) {
        return MacroUtils.replaceMacros(hasMacroStr, keyValues, null, false, macros);
    }

    public static String replaceMacros(String hasMacroStr, Map<String, Object> keyValues, Object paramsValues, boolean isOuter, Map<String, AbstractMacro> macros) {
        if (StringUtil.isBlank(hasMacroStr)) {
            return hasMacroStr;
        }
        if (StringUtil.matches(hasMacroStr, macroPattern)) {
            String source = hasMacroStr;
            Matcher matcher = macroPattern.matcher(source);
            String matchedMacro = null;
            String tmpMatchedMacro = null;
            int count = 0;
            int macroIndex = 0;
            int index = 0;
            int startIndex = 0;
            while (matcher.find()) {
                index = matcher.start();
                tmpMatchedMacro = matcher.group();
                if (MacroUtils.isMacro(macros, tmpMatchedMacro, true)) {
                    ++count;
                    matchedMacro = tmpMatchedMacro;
                    macroIndex = startIndex + index;
                    if (isOuter) break;
                }
                startIndex = startIndex + index + 1;
                source = source.substring(index + 1);
                matcher = macroPattern.matcher(source);
            }
            if (count == 0) {
                return hasMacroStr;
            }
            int sysMarkIndex = StringUtil.getSymMarkIndex("(", ")", matchedMacro, 0);
            String preSql = macroIndex > 0 ? hasMacroStr.substring(0, macroIndex) : "";
            String macroParam = matchedMacro.substring(matchedMacro.indexOf("(") + 1, sysMarkIndex);
            String macroName = matchedMacro.substring(0, matchedMacro.indexOf("("));
            String macroStr = matchedMacro.substring(0, sysMarkIndex + 1);
            AbstractMacro macro = macros.get(macroName);
            String result = macro.execute(StringUtil.splitExcludeSymMark(macroParam, ",", filters), keyValues, paramsValues, preSql);
            if (hasMacroStr.trim().equals(macroStr.trim())) {
                return result;
            }
            String macroResult = result == null ? "" : result;
            hasMacroStr = MacroUtils.replaceStr(hasMacroStr, macroStr, macroResult, macroIndex);
            return MacroUtils.replaceMacros(hasMacroStr, keyValues, paramsValues, isOuter, macros);
        }
        return hasMacroStr;
    }

    private static boolean isMacro(Map<String, AbstractMacro> macros, String matchedStr, boolean isStart) {
        int index = matchedStr.indexOf("(");
        return matchedStr.startsWith("@") && index != -1 && macros.containsKey(matchedStr.substring(0, index));
    }

    private static String replaceStr(String source, String template, String target, int fromIndex) {
        if (source == null) {
            return null;
        }
        if (template == null) {
            return source;
        }
        if (fromIndex >= source.length() - 1) {
            return source;
        }
        int index = source.indexOf(template, fromIndex);
        if (index != -1) {
            source = source.substring(0, index).concat(target).concat(source.substring(index + template.length()));
        }
        return source;
    }

    public static String replaceParams(String template, Map<String, Object> keyValues) {
        if (StringUtil.isBlank(template) || keyValues == null || keyValues.isEmpty()) {
            return template;
        }
        LinkedHashMap<String, String> paramsMap = MacroUtils.parseParams(template);
        String result = template;
        if (paramsMap.size() > 0) {
            for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                Object value = keyValues.get(entry.getValue());
                if (value == null) continue;
                result = MacroUtils.replaceAllStr(result, entry.getKey().toString(), value.toString());
            }
        }
        return result;
    }

    private static LinkedHashMap<String, String> parseParams(String template) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        Matcher m = paramPattern.matcher(template);
        while (m.find()) {
            String group = m.group();
            paramsMap.put(group, group.substring(2, group.length() - 1).trim().toLowerCase());
        }
        return paramsMap;
    }

    private static String replaceAllStr(String source, String template, String target) {
        if (source == null || template.equals(target)) {
            return source;
        }
        int index = source.indexOf(template, 0);
        int subLength = target.length() - template.length();
        int begin = index - 1;
        while (index != -1 && index >= begin) {
            source = source.substring(0, index).concat(target).concat(source.substring(index + template.length()));
            begin = index + subLength + 1;
            index = source.indexOf(template, begin);
        }
        return source;
    }

    static {
        macros.put("@df", new DateFormat());
        macros.put("@day", new DateFormat());
        macros.put("@case", new Case());
        macros.put("@substr", new SubString());
        macros.put("@substring", new SubString());
    }
}

