/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config.model;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.sagacity.sqltoy.utils.FileUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class ElasticEndpoint
implements Serializable {
    private static final long serialVersionUID = 7850474153384016421L;
    private RestClient restClient;
    private String sqlPath = "_sql";
    private String id;
    private String url;
    private String username;
    private String password;
    private boolean authCaching = true;
    private String keyStoreType;
    private String keyStore;
    private String keyStorePass;
    private boolean keyStoreSelfSign = true;
    private String charset = "UTF-8";
    private int requestTimeout = 30000;
    private int connectTimeout = 10000;
    private int socketTimeout = 180000;
    private boolean nativeSql = true;

    public ElasticEndpoint(String url) {
        this.url = url;
    }

    public ElasticEndpoint(String url, String sqlPath) {
        this.url = url;
        if (StringUtil.isNotBlank(sqlPath)) {
            this.sqlPath = sqlPath.startsWith("/") ? sqlPath.substring(1) : sqlPath;
            String sqlLowPath = this.sqlPath.toLowerCase();
            this.nativeSql = sqlLowPath.startsWith("_sql") || sqlLowPath.startsWith("_xpack/sql");
        }
    }

    public String getSqlPath() {
        return this.sqlPath;
    }

    public void setSqlPath(String sqlPath) {
        if (StringUtil.isNotBlank(sqlPath)) {
            this.sqlPath = sqlPath.startsWith("/") ? sqlPath.substring(1) : sqlPath;
            String sqlLowPath = this.sqlPath.toLowerCase();
            this.nativeSql = sqlLowPath.startsWith("_sql") || sqlLowPath.startsWith("_xpack/sql");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public boolean isNativeSql() {
        return this.nativeSql;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public boolean isKeyStoreSelfSign() {
        return this.keyStoreSelfSign;
    }

    public void setKeyStoreSelfSign(boolean keyStoreSelfSign) {
        this.keyStoreSelfSign = keyStoreSelfSign;
    }

    public boolean isAuthCaching() {
        return this.authCaching;
    }

    public void setAuthCaching(boolean authCaching) {
        this.authCaching = authCaching;
    }

    public void initRestClient() {
        if (StringUtil.isBlank(this.getUrl())) {
            return;
        }
        if (this.restClient == null) {
            String[] urls = this.getUrl().replaceAll("\\\uff1b", ";").replaceAll("\\\uff0c", ",").replaceAll("\\;", ",").split("\\,");
            if (urls.length < 2) {
                return;
            }
            ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
            for (String urlStr : urls) {
                try {
                    if (!StringUtil.isNotBlank(urlStr)) continue;
                    URL url = new URL(urlStr.trim());
                    hosts.add(new HttpHost(url.getHost(), url.getPort(), url.getProtocol()));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            if (!hosts.isEmpty()) {
                HttpHost[] hostAry = new HttpHost[hosts.size()];
                hosts.toArray(hostAry);
                RestClientBuilder builder = RestClient.builder((HttpHost[])hostAry);
                final ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Charset.forName(this.charset == null ? "UTF-8" : this.charset)).build();
                final RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.requestTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).build();
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                final boolean hasCrede = StringUtil.isNotBlank(this.getUsername()) && StringUtil.isNotBlank(this.getPassword());
                boolean hasSsl = StringUtil.isNotBlank(this.keyStore);
                if (hasCrede) {
                    credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword()));
                }
                SSLContextBuilder sslBuilder = null;
                try {
                    if (hasSsl) {
                        KeyStore truststore = KeyStore.getInstance(StringUtil.isBlank(this.keyStoreType) ? KeyStore.getDefaultType() : this.keyStoreType);
                        truststore.load(FileUtil.getFileInputStream(this.keyStore), this.keyStorePass == null ? null : this.keyStorePass.toCharArray());
                        sslBuilder = SSLContexts.custom().loadTrustMaterial(truststore, (TrustStrategy)(this.keyStoreSelfSign ? new TrustSelfSignedStrategy() : null));
                    }
                    SSLContext sslContext = sslBuilder == null ? null : sslBuilder.build();
                    final boolean disableAuthCaching = !this.authCaching;
                    builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){
                        final /* synthetic */ CredentialsProvider val$credsProvider;
                        final /* synthetic */ boolean val$hasSsl;
                        final /* synthetic */ SSLContext val$sslContext;
                        {
                            this.val$credsProvider = credentialsProvider;
                            this.val$hasSsl = bl3;
                            this.val$sslContext = sSLContext;
                        }

                        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                            httpClientBuilder.setDefaultConnectionConfig(connectionConfig).setDefaultRequestConfig(requestConfig);
                            if (disableAuthCaching) {
                                httpClientBuilder.disableAuthCaching();
                            }
                            if (hasCrede) {
                                httpClientBuilder.setDefaultCredentialsProvider(this.val$credsProvider);
                            }
                            if (this.val$hasSsl) {
                                httpClientBuilder.setSSLContext(this.val$sslContext);
                            }
                            return httpClientBuilder;
                        }
                    });
                    this.restClient = builder.build();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

