/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionException;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPASubQuery;
import com.querydsl.jpa.JPQLOps;
import com.querydsl.jpa.JPQLQuery;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import javax.persistence.Entity;

public final class JPAExpressions {
    public static <T> JPQLQuery<T> select(Expression<T> expr) {
        return new JPASubQuery().select((Expression)expr);
    }

    public static JPQLQuery<Tuple> select(Expression<?> ... exprs) {
        return new JPASubQuery().select((Expression[])exprs);
    }

    public static <T> JPQLQuery<T> selectDistinct(Expression<T> expr) {
        return (JPQLQuery)new JPASubQuery().select((Expression)expr).distinct();
    }

    public static JPQLQuery<Tuple> selectDistinct(Expression<?> ... exprs) {
        return (JPQLQuery)new JPASubQuery().select((Expression[])exprs).distinct();
    }

    public static JPQLQuery<Integer> selectZero() {
        return JPAExpressions.select(Expressions.ZERO);
    }

    public static JPQLQuery<Integer> selectOne() {
        return JPAExpressions.select(Expressions.ONE);
    }

    public static <T> JPQLQuery<T> selectFrom(EntityPath<T> expr) {
        return JPAExpressions.select(expr).from(expr);
    }

    public static <U extends BeanPath<? extends T>, T> U treat(BeanPath<? extends T> path, Class<U> subtype) {
        try {
            Class<T> entitySubType = JPAExpressions.getConcreteEntitySubType(subtype);
            PathMetadata pathMetadata = new PathMetadata(path, (Object)JPAExpressions.getEntityName(entitySubType), PathType.TREATED_PATH);
            return (U)((BeanPath)subtype.getConstructor(PathMetadata.class).newInstance(pathMetadata));
        }
        catch (InstantiationException e) {
            throw new ExpressionException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ExpressionException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ExpressionException(e.getMessage(), (Throwable)e);
        }
    }

    public static <A extends Comparable<? super A>> ComparableExpression<A> avg(CollectionExpression<?, A> col) {
        return Expressions.comparableOperation((Class)col.getParameter(0), (Operator)Ops.QuantOps.AVG_IN_COL, (Expression[])new Expression[]{col});
    }

    public static <A extends Comparable<? super A>> ComparableExpression<A> max(CollectionExpression<?, A> left) {
        return Expressions.comparableOperation((Class)left.getParameter(0), (Operator)Ops.QuantOps.MAX_IN_COL, (Expression[])new Expression[]{left});
    }

    public static <A extends Comparable<? super A>> ComparableExpression<A> min(CollectionExpression<?, A> left) {
        return Expressions.comparableOperation((Class)left.getParameter(0), (Operator)Ops.QuantOps.MIN_IN_COL, (Expression[])new Expression[]{left});
    }

    public static StringExpression type(EntityPath<?> path) {
        return Expressions.stringOperation((Operator)JPQLOps.TYPE, (Expression[])new Expression[]{path});
    }

    private static String getEntityName(Class<?> clazz) {
        Entity entityAnnotation = clazz.getAnnotation(Entity.class);
        if (entityAnnotation != null && entityAnnotation.name().length() > 0) {
            return entityAnnotation.name();
        }
        if (clazz.getPackage() != null) {
            String pn = clazz.getPackage().getName();
            return clazz.getName().substring(pn.length() + 1);
        }
        return clazz.getName();
    }

    private static <U extends BeanPath<? extends T>, T> Class<? extends T> getConcreteEntitySubType(Class<U> subtype) {
        return (Class)((ParameterizedType)subtype.getGenericSuperclass()).getActualTypeArguments()[0];
    }

    private JPAExpressions() {
    }
}

