/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.jpa.Conversions;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.ProjectableSQLQuery;
import jakarta.persistence.Entity;

public abstract class AbstractSQLQuery<T, Q extends AbstractSQLQuery<T, Q>>
extends ProjectableSQLQuery<T, Q> {
    public AbstractSQLQuery(QueryMetadata metadata, Configuration configuration) {
        super(new NativeQueryMixin(metadata), configuration);
        this.queryMixin.setSelf((Object)this);
    }

    protected boolean isEntityExpression(Expression<?> expr) {
        return expr instanceof EntityPath || expr.getType().isAnnotationPresent(Entity.class);
    }

    protected Expression<?> extractEntityExpression(Expression<?> expr) {
        if (expr instanceof Operation) {
            return ((Operation)expr).getArg(0);
        }
        if (expr instanceof TemplateExpression) {
            return (Expression)((TemplateExpression)expr).getArg(0);
        }
        return expr;
    }

    private static final class NativeQueryMixin<T>
    extends QueryMixin<T> {
        private NativeQueryMixin(QueryMetadata metadata) {
            super(metadata, false);
        }

        public <RT> Expression<RT> convert(Expression<RT> expr, QueryMixin.Role role) {
            return Conversions.convertForNativeQuery(super.convert(expr, role));
        }
    }
}

