/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.annotations.Immutable;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathType;
import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class PathMetadata
implements Serializable {
    private static final long serialVersionUID = -1055994185028970065L;
    private final Object element;
    private final int hashCode;
    @Nullable
    private final Path<?> parent;
    @Nullable
    private final Path<?> rootPath;
    private final PathType pathType;

    public PathMetadata(@Nullable Path<?> parent, Object element, PathType type) {
        this.parent = parent;
        this.element = element;
        this.pathType = type;
        this.rootPath = parent != null ? parent.getRoot() : null;
        this.hashCode = 31 * element.hashCode() + this.pathType.name().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PathMetadata) {
            PathMetadata p = (PathMetadata)obj;
            return this.element.equals(p.element) && this.pathType == p.pathType && Objects.equals(this.parent, p.parent);
        }
        return false;
    }

    public Object getElement() {
        return this.element;
    }

    public String getName() {
        if (this.pathType == PathType.VARIABLE || this.pathType == PathType.PROPERTY) {
            return (String)this.element;
        }
        throw new IllegalStateException("name property not available for path of type " + this.pathType + ". Use getElement() to access the generic path element.");
    }

    @Nullable
    public Path<?> getParent() {
        return this.parent;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    @Nullable
    public Path<?> getRootPath() {
        return this.rootPath;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isRoot() {
        return this.parent == null || this.pathType == PathType.DELEGATE && this.parent.getMetadata().isRoot();
    }
}

