/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Locale;

@StatelessCheck
public abstract class AbstractParenPadCheck
extends AbstractCheck {
    public static final String MSG_WS_FOLLOWED = "ws.followed";
    public static final String MSG_WS_NOT_FOLLOWED = "ws.notFollowed";
    public static final String MSG_WS_PRECEDED = "ws.preceded";
    public static final String MSG_WS_NOT_PRECEDED = "ws.notPreceded";
    private static final char OPEN_PARENTHESIS = '(';
    private static final char CLOSE_PARENTHESIS = ')';
    private PadOption option = PadOption.NOSPACE;

    public void setOption(String optionStr) {
        this.option = PadOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
    }

    protected void processLeft(DetailAST ast) {
        String line = this.getLines()[ast.getLineNo() - 1];
        int[] codePoints = line.codePoints().toArray();
        int after = ast.getColumnNo() + 1;
        if (after < codePoints.length) {
            boolean hasWhitespaceAfter = CommonUtil.isCodePointWhitespace(codePoints, after);
            if (this.option == PadOption.NOSPACE && hasWhitespaceAfter) {
                this.log(ast, MSG_WS_FOLLOWED, Character.valueOf('('));
            } else if (this.option == PadOption.SPACE && !hasWhitespaceAfter && line.charAt(after) != ')') {
                this.log(ast, MSG_WS_NOT_FOLLOWED, Character.valueOf('('));
            }
        }
    }

    protected void processRight(DetailAST ast) {
        int before = ast.getColumnNo() - 1;
        if (before >= 0) {
            String line = this.getLines()[ast.getLineNo() - 1];
            int[] codePoints = line.codePoints().toArray();
            boolean hasPrecedingWhitespace = CommonUtil.isCodePointWhitespace(codePoints, before);
            if (this.option == PadOption.NOSPACE && hasPrecedingWhitespace && !CommonUtil.hasWhitespaceBefore(before, line)) {
                this.log(ast, MSG_WS_PRECEDED, Character.valueOf(')'));
            } else if (this.option == PadOption.SPACE && !hasPrecedingWhitespace && line.charAt(before) != '(') {
                this.log(ast, MSG_WS_NOT_PRECEDED, Character.valueOf(')'));
            }
        }
    }
}

