/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.Violation;
import java.util.EventObject;

public final class AuditEvent
extends EventObject {
    private static final long serialVersionUID = -3774725606973812736L;
    private final String fileName;
    private final Violation violation;

    public AuditEvent(Object source) {
        this(source, null);
    }

    public AuditEvent(Object src, String fileName) {
        this(src, fileName, null);
    }

    public AuditEvent(Object src, String fileName, Violation violation) {
        super(src);
        this.fileName = fileName;
        this.violation = violation;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLine() {
        return this.violation.getLineNo();
    }

    public String getMessage() {
        return this.violation.getViolation();
    }

    public int getColumn() {
        return this.violation.getColumnNo();
    }

    public SeverityLevel getSeverityLevel() {
        SeverityLevel severityLevel = SeverityLevel.INFO;
        if (this.violation != null) {
            severityLevel = this.violation.getSeverityLevel();
        }
        return severityLevel;
    }

    public String getModuleId() {
        return this.violation.getModuleId();
    }

    public String getSourceName() {
        return this.violation.getSourceName();
    }

    public Violation getViolation() {
        return this.violation;
    }
}

