/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class OBinaryTypeSerializer
implements OBinarySerializer<byte[]> {
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static final OBinaryTypeSerializer INSTANCE = new OBinaryTypeSerializer();
    public static final byte ID = 17;

    @Override
    public int getObjectSize(int length) {
        return length + 4;
    }

    @Override
    public int getObjectSize(byte[] object) {
        return object.length + 4;
    }

    @Override
    public void serialize(byte[] object, byte[] stream, int startPosition) {
        int len = object.length;
        OIntegerSerializer.INSTANCE.serialize(len, stream, startPosition);
        System.arraycopy(object, 0, stream, startPosition + 4, len);
    }

    @Override
    public byte[] deserialize(byte[] stream, int startPosition) {
        int len = OIntegerSerializer.INSTANCE.deserialize(stream, startPosition);
        return Arrays.copyOfRange(stream, startPosition + 4, startPosition + 4 + len);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserialize(stream, startPosition) + 4;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return CONVERTER.getInt(stream, startPosition, ByteOrder.nativeOrder()) + 4;
    }

    @Override
    public void serializeNative(byte[] object, byte[] stream, int startPosition) {
        int len = object.length;
        CONVERTER.putInt(stream, startPosition, len, ByteOrder.nativeOrder());
        System.arraycopy(object, 0, stream, startPosition + 4, len);
    }

    @Override
    public byte[] deserializeNative(byte[] stream, int startPosition) {
        int len = CONVERTER.getInt(stream, startPosition, ByteOrder.nativeOrder());
        return Arrays.copyOfRange(stream, startPosition + 4, startPosition + 4 + len);
    }

    @Override
    public void serializeInDirectMemory(byte[] object, ODirectMemory memory, long pointer) {
        int len = object.length;
        memory.setInt(pointer, len);
        memory.set(pointer += 4L, object, 0, len);
    }

    @Override
    public byte[] deserializeFromDirectMemory(ODirectMemory memory, long pointer) {
        int len = memory.getInt(pointer);
        return memory.get(pointer += 4L, len);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemory memory, long pointer) {
        return memory.getInt(pointer) + 4;
    }

    @Override
    public byte getId() {
        return 17;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }
}

