/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.offbytwo.jenkins.model.BaseModel;
import com.offbytwo.jenkins.model.BuildWithDetails;
import java.io.IOException;
import org.apache.http.client.HttpResponseException;

public class Build
extends BaseModel {
    int number;
    String url;

    public Build() {
    }

    public Build(Build from) {
        this(from.getNumber(), from.getUrl());
    }

    public Build(int number, String url) {
        this.number = number;
        this.url = url;
    }

    public int getNumber() {
        return this.number;
    }

    public String getUrl() {
        return this.url;
    }

    public BuildWithDetails details() throws IOException {
        return this.client.get(this.url, BuildWithDetails.class);
    }

    public String Stop() throws HttpResponseException, IOException {
        try {
            return this.client.get(this.url + "stop");
        }
        catch (IOException ex) {
            if (((HttpResponseException)((Object)ex)).getStatusCode() == 405) {
                this.stopPost();
                return "";
            }
            return "";
        }
    }

    private void stopPost() throws HttpResponseException, IOException {
        this.client.post(this.url + "stop");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Build build = (Build)o;
        if (this.number != build.number) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(build.url) : build.url != null);
    }

    public int hashCode() {
        int result = this.number;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }
}

