/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.google.common.collect.Maps;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.jpa.JPQLOps;
import com.mysema.query.support.Expressions;
import com.mysema.query.support.ReplaceVisitor;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathType;
import java.util.Map;
import javax.annotation.Nullable;

class JPAListAccessVisitor
extends ReplaceVisitor {
    private final QueryMetadata metadata;
    private final Map<Path<?>, Path<?>> replacements = Maps.newHashMap();

    public JPAListAccessVisitor(QueryMetadata metadata) {
        this.metadata = metadata;
    }

    public Expression<?> visit(Path<?> expr, @Nullable Void context) {
        PathMetadata pathMetadata = (expr = (Path)super.visit(expr, null)).getMetadata();
        if (pathMetadata.getPathType() == PathType.LISTVALUE || pathMetadata.getPathType() == PathType.LISTVALUE_CONSTANT) {
            PathImpl replacement = this.replacements.get(expr);
            if (replacement == null) {
                Path parent = pathMetadata.getParent();
                replacement = new PathImpl(expr.getType(), ExpressionUtils.createRootVariable((Path)parent));
                this.metadata.addJoin(JoinType.LEFTJOIN, ExpressionUtils.as((Expression)parent, (Path)replacement));
                this.metadata.addJoinCondition(ExpressionUtils.eq((Expression)Expressions.operation(Integer.class, JPQLOps.INDEX, (Expression[])new Expression[]{replacement}), (Expression)ExpressionUtils.toExpression((Object)pathMetadata.getElement())));
                this.replacements.put((Path<?>)expr, (Path<?>)replacement);
            }
            return replacement;
        }
        return super.visit(expr, context);
    }
}

