/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+B5xx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class Xb5 {

    public static final String[] map = new String[]{
        "dyil", // 0x00
        "dyilg", // 0x01
        "dyilm", // 0x02
        "dyilb", // 0x03
        "dyils", // 0x04
        "dyilt", // 0x05
        "dyilp", // 0x06
        "dyilh", // 0x07
        "dyim", // 0x08
        "dyib", // 0x09
        "dyibs", // 0x0a
        "dyis", // 0x0b
        "dyiss", // 0x0c
        "dying", // 0x0d
        "dyij", // 0x0e
        "dyic", // 0x0f
        "dyik", // 0x10
        "dyit", // 0x11
        "dyip", // 0x12
        "dyih", // 0x13
        "di", // 0x14
        "dig", // 0x15
        "digg", // 0x16
        "digs", // 0x17
        "din", // 0x18
        "dinj", // 0x19
        "dinh", // 0x1a
        "did", // 0x1b
        "dil", // 0x1c
        "dilg", // 0x1d
        "dilm", // 0x1e
        "dilb", // 0x1f
        "dils", // 0x20
        "dilt", // 0x21
        "dilp", // 0x22
        "dilh", // 0x23
        "dim", // 0x24
        "dib", // 0x25
        "dibs", // 0x26
        "dis", // 0x27
        "diss", // 0x28
        "ding", // 0x29
        "dij", // 0x2a
        "dic", // 0x2b
        "dik", // 0x2c
        "dit", // 0x2d
        "dip", // 0x2e
        "dih", // 0x2f
        "dda", // 0x30
        "ddag", // 0x31
        "ddagg", // 0x32
        "ddags", // 0x33
        "ddan", // 0x34
        "ddanj", // 0x35
        "ddanh", // 0x36
        "ddad", // 0x37
        "ddal", // 0x38
        "ddalg", // 0x39
        "ddalm", // 0x3a
        "ddalb", // 0x3b
        "ddals", // 0x3c
        "ddalt", // 0x3d
        "ddalp", // 0x3e
        "ddalh", // 0x3f
        "ddam", // 0x40
        "ddab", // 0x41
        "ddabs", // 0x42
        "ddas", // 0x43
        "ddass", // 0x44
        "ddang", // 0x45
        "ddaj", // 0x46
        "ddac", // 0x47
        "ddak", // 0x48
        "ddat", // 0x49
        "ddap", // 0x4a
        "ddah", // 0x4b
        "ddae", // 0x4c
        "ddaeg", // 0x4d
        "ddaegg", // 0x4e
        "ddaegs", // 0x4f
        "ddaen", // 0x50
        "ddaenj", // 0x51
        "ddaenh", // 0x52
        "ddaed", // 0x53
        "ddael", // 0x54
        "ddaelg", // 0x55
        "ddaelm", // 0x56
        "ddaelb", // 0x57
        "ddaels", // 0x58
        "ddaelt", // 0x59
        "ddaelp", // 0x5a
        "ddaelh", // 0x5b
        "ddaem", // 0x5c
        "ddaeb", // 0x5d
        "ddaebs", // 0x5e
        "ddaes", // 0x5f
        "ddaess", // 0x60
        "ddaeng", // 0x61
        "ddaej", // 0x62
        "ddaec", // 0x63
        "ddaek", // 0x64
        "ddaet", // 0x65
        "ddaep", // 0x66
        "ddaeh", // 0x67
        "ddya", // 0x68
        "ddyag", // 0x69
        "ddyagg", // 0x6a
        "ddyags", // 0x6b
        "ddyan", // 0x6c
        "ddyanj", // 0x6d
        "ddyanh", // 0x6e
        "ddyad", // 0x6f
        "ddyal", // 0x70
        "ddyalg", // 0x71
        "ddyalm", // 0x72
        "ddyalb", // 0x73
        "ddyals", // 0x74
        "ddyalt", // 0x75
        "ddyalp", // 0x76
        "ddyalh", // 0x77
        "ddyam", // 0x78
        "ddyab", // 0x79
        "ddyabs", // 0x7a
        "ddyas", // 0x7b
        "ddyass", // 0x7c
        "ddyang", // 0x7d
        "ddyaj", // 0x7e
        "ddyac", // 0x7f
        "ddyak", // 0x80
        "ddyat", // 0x81
        "ddyap", // 0x82
        "ddyah", // 0x83
        "ddyae", // 0x84
        "ddyaeg", // 0x85
        "ddyaegg", // 0x86
        "ddyaegs", // 0x87
        "ddyaen", // 0x88
        "ddyaenj", // 0x89
        "ddyaenh", // 0x8a
        "ddyaed", // 0x8b
        "ddyael", // 0x8c
        "ddyaelg", // 0x8d
        "ddyaelm", // 0x8e
        "ddyaelb", // 0x8f
        "ddyaels", // 0x90
        "ddyaelt", // 0x91
        "ddyaelp", // 0x92
        "ddyaelh", // 0x93
        "ddyaem", // 0x94
        "ddyaeb", // 0x95
        "ddyaebs", // 0x96
        "ddyaes", // 0x97
        "ddyaess", // 0x98
        "ddyaeng", // 0x99
        "ddyaej", // 0x9a
        "ddyaec", // 0x9b
        "ddyaek", // 0x9c
        "ddyaet", // 0x9d
        "ddyaep", // 0x9e
        "ddyaeh", // 0x9f
        "ddeo", // 0xa0
        "ddeog", // 0xa1
        "ddeogg", // 0xa2
        "ddeogs", // 0xa3
        "ddeon", // 0xa4
        "ddeonj", // 0xa5
        "ddeonh", // 0xa6
        "ddeod", // 0xa7
        "ddeol", // 0xa8
        "ddeolg", // 0xa9
        "ddeolm", // 0xaa
        "ddeolb", // 0xab
        "ddeols", // 0xac
        "ddeolt", // 0xad
        "ddeolp", // 0xae
        "ddeolh", // 0xaf
        "ddeom", // 0xb0
        "ddeob", // 0xb1
        "ddeobs", // 0xb2
        "ddeos", // 0xb3
        "ddeoss", // 0xb4
        "ddeong", // 0xb5
        "ddeoj", // 0xb6
        "ddeoc", // 0xb7
        "ddeok", // 0xb8
        "ddeot", // 0xb9
        "ddeop", // 0xba
        "ddeoh", // 0xbb
        "dde", // 0xbc
        "ddeg", // 0xbd
        "ddegg", // 0xbe
        "ddegs", // 0xbf
        "dden", // 0xc0
        "ddenj", // 0xc1
        "ddenh", // 0xc2
        "dded", // 0xc3
        "ddel", // 0xc4
        "ddelg", // 0xc5
        "ddelm", // 0xc6
        "ddelb", // 0xc7
        "ddels", // 0xc8
        "ddelt", // 0xc9
        "ddelp", // 0xca
        "ddelh", // 0xcb
        "ddem", // 0xcc
        "ddeb", // 0xcd
        "ddebs", // 0xce
        "ddes", // 0xcf
        "ddess", // 0xd0
        "ddeng", // 0xd1
        "ddej", // 0xd2
        "ddec", // 0xd3
        "ddek", // 0xd4
        "ddet", // 0xd5
        "ddep", // 0xd6
        "ddeh", // 0xd7
        "ddyeo", // 0xd8
        "ddyeog", // 0xd9
        "ddyeogg", // 0xda
        "ddyeogs", // 0xdb
        "ddyeon", // 0xdc
        "ddyeonj", // 0xdd
        "ddyeonh", // 0xde
        "ddyeod", // 0xdf
        "ddyeol", // 0xe0
        "ddyeolg", // 0xe1
        "ddyeolm", // 0xe2
        "ddyeolb", // 0xe3
        "ddyeols", // 0xe4
        "ddyeolt", // 0xe5
        "ddyeolp", // 0xe6
        "ddyeolh", // 0xe7
        "ddyeom", // 0xe8
        "ddyeob", // 0xe9
        "ddyeobs", // 0xea
        "ddyeos", // 0xeb
        "ddyeoss", // 0xec
        "ddyeong", // 0xed
        "ddyeoj", // 0xee
        "ddyeoc", // 0xef
        "ddyeok", // 0xf0
        "ddyeot", // 0xf1
        "ddyeop", // 0xf2
        "ddyeoh", // 0xf3
        "ddye", // 0xf4
        "ddyeg", // 0xf5
        "ddyegg", // 0xf6
        "ddyegs", // 0xf7
        "ddyen", // 0xf8
        "ddyenj", // 0xf9
        "ddyenh", // 0xfa
        "ddyed", // 0xfb
        "ddyel", // 0xfc
        "ddyelg", // 0xfd
        "ddyelm", // 0xfe
        "ddyelb" // 0xff
    };
}
