/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+97xx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class X97 {

    public static final String[] map = new String[]{
        "Xu ", // 0x00
        "Ji ", // 0x01
        "Mu ", // 0x02
        "Chen ", // 0x03
        "Xiao ", // 0x04
        "Zha ", // 0x05
        "Ting ", // 0x06
        "Zhen ", // 0x07
        "Pei ", // 0x08
        "Mei ", // 0x09
        "Ling ", // 0x0a
        "Qi ", // 0x0b
        "Chou ", // 0x0c
        "Huo ", // 0x0d
        "Sha ", // 0x0e
        "Fei ", // 0x0f
        "Weng ", // 0x10
        "Zhan ", // 0x11
        "Yin ", // 0x12
        "Ni ", // 0x13
        "Chou ", // 0x14
        "Tun ", // 0x15
        "Lin ", // 0x16
        "[?] ", // 0x17
        "Dong ", // 0x18
        "Ying ", // 0x19
        "Wu ", // 0x1a
        "Ling ", // 0x1b
        "Shuang ", // 0x1c
        "Ling ", // 0x1d
        "Xia ", // 0x1e
        "Hong ", // 0x1f
        "Yin ", // 0x20
        "Mo ", // 0x21
        "Mai ", // 0x22
        "Yun ", // 0x23
        "Liu ", // 0x24
        "Meng ", // 0x25
        "Bin ", // 0x26
        "Wu ", // 0x27
        "Wei ", // 0x28
        "Huo ", // 0x29
        "Yin ", // 0x2a
        "Xi ", // 0x2b
        "Yi ", // 0x2c
        "Ai ", // 0x2d
        "Dan ", // 0x2e
        "Deng ", // 0x2f
        "Xian ", // 0x30
        "Yu ", // 0x31
        "Lu ", // 0x32
        "Long ", // 0x33
        "Dai ", // 0x34
        "Ji ", // 0x35
        "Pang ", // 0x36
        "Yang ", // 0x37
        "Ba ", // 0x38
        "Pi ", // 0x39
        "Wei ", // 0x3a
        "[?] ", // 0x3b
        "Xi ", // 0x3c
        "Ji ", // 0x3d
        "Mai ", // 0x3e
        "Meng ", // 0x3f
        "Meng ", // 0x40
        "Lei ", // 0x41
        "Li ", // 0x42
        "Huo ", // 0x43
        "Ai ", // 0x44
        "Fei ", // 0x45
        "Dai ", // 0x46
        "Long ", // 0x47
        "Ling ", // 0x48
        "Ai ", // 0x49
        "Feng ", // 0x4a
        "Li ", // 0x4b
        "Bao ", // 0x4c
        "[?] ", // 0x4d
        "He ", // 0x4e
        "He ", // 0x4f
        "Bing ", // 0x50
        "Qing ", // 0x51
        "Qing ", // 0x52
        "Jing ", // 0x53
        "Tian ", // 0x54
        "Zhen ", // 0x55
        "Jing ", // 0x56
        "Cheng ", // 0x57
        "Qing ", // 0x58
        "Jing ", // 0x59
        "Jing ", // 0x5a
        "Dian ", // 0x5b
        "Jing ", // 0x5c
        "Tian ", // 0x5d
        "Fei ", // 0x5e
        "Fei ", // 0x5f
        "Kao ", // 0x60
        "Mi ", // 0x61
        "Mian ", // 0x62
        "Mian ", // 0x63
        "Pao ", // 0x64
        "Ye ", // 0x65
        "Tian ", // 0x66
        "Hui ", // 0x67
        "Ye ", // 0x68
        "Ge ", // 0x69
        "Ding ", // 0x6a
        "Cha ", // 0x6b
        "Jian ", // 0x6c
        "Ren ", // 0x6d
        "Di ", // 0x6e
        "Du ", // 0x6f
        "Wu ", // 0x70
        "Ren ", // 0x71
        "Qin ", // 0x72
        "Jin ", // 0x73
        "Xue ", // 0x74
        "Niu ", // 0x75
        "Ba ", // 0x76
        "Yin ", // 0x77
        "Sa ", // 0x78
        "Na ", // 0x79
        "Mo ", // 0x7a
        "Zu ", // 0x7b
        "Da ", // 0x7c
        "Ban ", // 0x7d
        "Yi ", // 0x7e
        "Yao ", // 0x7f
        "Tao ", // 0x80
        "Tuo ", // 0x81
        "Jia ", // 0x82
        "Hong ", // 0x83
        "Pao ", // 0x84
        "Yang ", // 0x85
        "Tomo ", // 0x86
        "Yin ", // 0x87
        "Jia ", // 0x88
        "Tao ", // 0x89
        "Ji ", // 0x8a
        "Xie ", // 0x8b
        "An ", // 0x8c
        "An ", // 0x8d
        "Hen ", // 0x8e
        "Gong ", // 0x8f
        "Kohaze ", // 0x90
        "Da ", // 0x91
        "Qiao ", // 0x92
        "Ting ", // 0x93
        "Wan ", // 0x94
        "Ying ", // 0x95
        "Sui ", // 0x96
        "Tiao ", // 0x97
        "Qiao ", // 0x98
        "Xuan ", // 0x99
        "Kong ", // 0x9a
        "Beng ", // 0x9b
        "Ta ", // 0x9c
        "Zhang ", // 0x9d
        "Bing ", // 0x9e
        "Kuo ", // 0x9f
        "Ju ", // 0xa0
        "La ", // 0xa1
        "Xie ", // 0xa2
        "Rou ", // 0xa3
        "Bang ", // 0xa4
        "Yi ", // 0xa5
        "Qiu ", // 0xa6
        "Qiu ", // 0xa7
        "He ", // 0xa8
        "Xiao ", // 0xa9
        "Mu ", // 0xaa
        "Ju ", // 0xab
        "Jian ", // 0xac
        "Bian ", // 0xad
        "Di ", // 0xae
        "Jian ", // 0xaf
        "On ", // 0xb0
        "Tao ", // 0xb1
        "Gou ", // 0xb2
        "Ta ", // 0xb3
        "Bei ", // 0xb4
        "Xie ", // 0xb5
        "Pan ", // 0xb6
        "Ge ", // 0xb7
        "Bi ", // 0xb8
        "Kuo ", // 0xb9
        "Tang ", // 0xba
        "Lou ", // 0xbb
        "Gui ", // 0xbc
        "Qiao ", // 0xbd
        "Xue ", // 0xbe
        "Ji ", // 0xbf
        "Jian ", // 0xc0
        "Jiang ", // 0xc1
        "Chan ", // 0xc2
        "Da ", // 0xc3
        "Huo ", // 0xc4
        "Xian ", // 0xc5
        "Qian ", // 0xc6
        "Du ", // 0xc7
        "Wa ", // 0xc8
        "Jian ", // 0xc9
        "Lan ", // 0xca
        "Wei ", // 0xcb
        "Ren ", // 0xcc
        "Fu ", // 0xcd
        "Mei ", // 0xce
        "Juan ", // 0xcf
        "Ge ", // 0xd0
        "Wei ", // 0xd1
        "Qiao ", // 0xd2
        "Han ", // 0xd3
        "Chang ", // 0xd4
        "[?] ", // 0xd5
        "Rou ", // 0xd6
        "Xun ", // 0xd7
        "She ", // 0xd8
        "Wei ", // 0xd9
        "Ge ", // 0xda
        "Bei ", // 0xdb
        "Tao ", // 0xdc
        "Gou ", // 0xdd
        "Yun ", // 0xde
        "[?] ", // 0xdf
        "Bi ", // 0xe0
        "Wei ", // 0xe1
        "Hui ", // 0xe2
        "Du ", // 0xe3
        "Wa ", // 0xe4
        "Du ", // 0xe5
        "Wei ", // 0xe6
        "Ren ", // 0xe7
        "Fu ", // 0xe8
        "Han ", // 0xe9
        "Wei ", // 0xea
        "Yun ", // 0xeb
        "Tao ", // 0xec
        "Jiu ", // 0xed
        "Jiu ", // 0xee
        "Xian ", // 0xef
        "Xie ", // 0xf0
        "Xian ", // 0xf1
        "Ji ", // 0xf2
        "Yin ", // 0xf3
        "Za ", // 0xf4
        "Yun ", // 0xf5
        "Shao ", // 0xf6
        "Le ", // 0xf7
        "Peng ", // 0xf8
        "Heng ", // 0xf9
        "Ying ", // 0xfa
        "Yun ", // 0xfb
        "Peng ", // 0xfc
        "Yin ", // 0xfd
        "Yin ", // 0xfe
        "Xiang " // 0xff
    };
}
