/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+75xx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class X75 {

    public static final String[] map = new String[]{
        "Zhui ", // 0x00
        "Ping ", // 0x01
        "Bian ", // 0x02
        "Zhou ", // 0x03
        "Zhen ", // 0x04
        "Senchigura ", // 0x05
        "Ci ", // 0x06
        "Ying ", // 0x07
        "Qi ", // 0x08
        "Xian ", // 0x09
        "Lou ", // 0x0a
        "Di ", // 0x0b
        "Ou ", // 0x0c
        "Meng ", // 0x0d
        "Zhuan ", // 0x0e
        "Peng ", // 0x0f
        "Lin ", // 0x10
        "Zeng ", // 0x11
        "Wu ", // 0x12
        "Pi ", // 0x13
        "Dan ", // 0x14
        "Weng ", // 0x15
        "Ying ", // 0x16
        "Yan ", // 0x17
        "Gan ", // 0x18
        "Dai ", // 0x19
        "Shen ", // 0x1a
        "Tian ", // 0x1b
        "Tian ", // 0x1c
        "Han ", // 0x1d
        "Chang ", // 0x1e
        "Sheng ", // 0x1f
        "Qing ", // 0x20
        "Sheng ", // 0x21
        "Chan ", // 0x22
        "Chan ", // 0x23
        "Rui ", // 0x24
        "Sheng ", // 0x25
        "Su ", // 0x26
        "Sen ", // 0x27
        "Yong ", // 0x28
        "Shuai ", // 0x29
        "Lu ", // 0x2a
        "Fu ", // 0x2b
        "Yong ", // 0x2c
        "Beng ", // 0x2d
        "Feng ", // 0x2e
        "Ning ", // 0x2f
        "Tian ", // 0x30
        "You ", // 0x31
        "Jia ", // 0x32
        "Shen ", // 0x33
        "Zha ", // 0x34
        "Dian ", // 0x35
        "Fu ", // 0x36
        "Nan ", // 0x37
        "Dian ", // 0x38
        "Ping ", // 0x39
        "Ting ", // 0x3a
        "Hua ", // 0x3b
        "Ting ", // 0x3c
        "Quan ", // 0x3d
        "Zi ", // 0x3e
        "Meng ", // 0x3f
        "Bi ", // 0x40
        "Qi ", // 0x41
        "Liu ", // 0x42
        "Xun ", // 0x43
        "Liu ", // 0x44
        "Chang ", // 0x45
        "Mu ", // 0x46
        "Yun ", // 0x47
        "Fan ", // 0x48
        "Fu ", // 0x49
        "Geng ", // 0x4a
        "Tian ", // 0x4b
        "Jie ", // 0x4c
        "Jie ", // 0x4d
        "Quan ", // 0x4e
        "Wei ", // 0x4f
        "Fu ", // 0x50
        "Tian ", // 0x51
        "Mu ", // 0x52
        "Tap ", // 0x53
        "Pan ", // 0x54
        "Jiang ", // 0x55
        "Wa ", // 0x56
        "Da ", // 0x57
        "Nan ", // 0x58
        "Liu ", // 0x59
        "Ben ", // 0x5a
        "Zhen ", // 0x5b
        "Chu ", // 0x5c
        "Mu ", // 0x5d
        "Mu ", // 0x5e
        "Ce ", // 0x5f
        "Cen ", // 0x60
        "Gai ", // 0x61
        "Bi ", // 0x62
        "Da ", // 0x63
        "Zhi ", // 0x64
        "Lue ", // 0x65
        "Qi ", // 0x66
        "Lue ", // 0x67
        "Pan ", // 0x68
        "Kesa ", // 0x69
        "Fan ", // 0x6a
        "Hua ", // 0x6b
        "Yu ", // 0x6c
        "Yu ", // 0x6d
        "Mu ", // 0x6e
        "Jun ", // 0x6f
        "Yi ", // 0x70
        "Liu ", // 0x71
        "Yu ", // 0x72
        "Die ", // 0x73
        "Chou ", // 0x74
        "Hua ", // 0x75
        "Dang ", // 0x76
        "Chuo ", // 0x77
        "Ji ", // 0x78
        "Wan ", // 0x79
        "Jiang ", // 0x7a
        "Sheng ", // 0x7b
        "Chang ", // 0x7c
        "Tuan ", // 0x7d
        "Lei ", // 0x7e
        "Ji ", // 0x7f
        "Cha ", // 0x80
        "Liu ", // 0x81
        "Tatamu ", // 0x82
        "Tuan ", // 0x83
        "Lin ", // 0x84
        "Jiang ", // 0x85
        "Jiang ", // 0x86
        "Chou ", // 0x87
        "Bo ", // 0x88
        "Die ", // 0x89
        "Die ", // 0x8a
        "Pi ", // 0x8b
        "Nie ", // 0x8c
        "Dan ", // 0x8d
        "Shu ", // 0x8e
        "Shu ", // 0x8f
        "Zhi ", // 0x90
        "Yi ", // 0x91
        "Chuang ", // 0x92
        "Nai ", // 0x93
        "Ding ", // 0x94
        "Bi ", // 0x95
        "Jie ", // 0x96
        "Liao ", // 0x97
        "Gong ", // 0x98
        "Ge ", // 0x99
        "Jiu ", // 0x9a
        "Zhou ", // 0x9b
        "Xia ", // 0x9c
        "Shan ", // 0x9d
        "Xu ", // 0x9e
        "Nue ", // 0x9f
        "Li ", // 0xa0
        "Yang ", // 0xa1
        "Chen ", // 0xa2
        "You ", // 0xa3
        "Ba ", // 0xa4
        "Jie ", // 0xa5
        "Jue ", // 0xa6
        "Zhi ", // 0xa7
        "Xia ", // 0xa8
        "Cui ", // 0xa9
        "Bi ", // 0xaa
        "Yi ", // 0xab
        "Li ", // 0xac
        "Zong ", // 0xad
        "Chuang ", // 0xae
        "Feng ", // 0xaf
        "Zhu ", // 0xb0
        "Pao ", // 0xb1
        "Pi ", // 0xb2
        "Gan ", // 0xb3
        "Ke ", // 0xb4
        "Ci ", // 0xb5
        "Xie ", // 0xb6
        "Qi ", // 0xb7
        "Dan ", // 0xb8
        "Zhen ", // 0xb9
        "Fa ", // 0xba
        "Zhi ", // 0xbb
        "Teng ", // 0xbc
        "Ju ", // 0xbd
        "Ji ", // 0xbe
        "Fei ", // 0xbf
        "Qu ", // 0xc0
        "Dian ", // 0xc1
        "Jia ", // 0xc2
        "Xian ", // 0xc3
        "Cha ", // 0xc4
        "Bing ", // 0xc5
        "Ni ", // 0xc6
        "Zheng ", // 0xc7
        "Yong ", // 0xc8
        "Jing ", // 0xc9
        "Quan ", // 0xca
        "Chong ", // 0xcb
        "Tong ", // 0xcc
        "Yi ", // 0xcd
        "Kai ", // 0xce
        "Wei ", // 0xcf
        "Hui ", // 0xd0
        "Duo ", // 0xd1
        "Yang ", // 0xd2
        "Chi ", // 0xd3
        "Zhi ", // 0xd4
        "Hen ", // 0xd5
        "Ya ", // 0xd6
        "Mei ", // 0xd7
        "Dou ", // 0xd8
        "Jing ", // 0xd9
        "Xiao ", // 0xda
        "Tong ", // 0xdb
        "Tu ", // 0xdc
        "Mang ", // 0xdd
        "Pi ", // 0xde
        "Xiao ", // 0xdf
        "Suan ", // 0xe0
        "Pu ", // 0xe1
        "Li ", // 0xe2
        "Zhi ", // 0xe3
        "Cuo ", // 0xe4
        "Duo ", // 0xe5
        "Wu ", // 0xe6
        "Sha ", // 0xe7
        "Lao ", // 0xe8
        "Shou ", // 0xe9
        "Huan ", // 0xea
        "Xian ", // 0xeb
        "Yi ", // 0xec
        "Peng ", // 0xed
        "Zhang ", // 0xee
        "Guan ", // 0xef
        "Tan ", // 0xf0
        "Fei ", // 0xf1
        "Ma ", // 0xf2
        "Lin ", // 0xf3
        "Chi ", // 0xf4
        "Ji ", // 0xf5
        "Dian ", // 0xf6
        "An ", // 0xf7
        "Chi ", // 0xf8
        "Bi ", // 0xf9
        "Bei ", // 0xfa
        "Min ", // 0xfb
        "Gu ", // 0xfc
        "Dui ", // 0xfd
        "E ", // 0xfe
        "Wei " // 0xff
    };
}
