/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+5Dxx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class X5d {

    public static final String[] map = new String[]{
        "Lang ", // 0x00
        "Kan ", // 0x01
        "Lao ", // 0x02
        "Lai ", // 0x03
        "Xian ", // 0x04
        "Que ", // 0x05
        "Kong ", // 0x06
        "Chong ", // 0x07
        "Chong ", // 0x08
        "Ta ", // 0x09
        "Lin ", // 0x0a
        "Hua ", // 0x0b
        "Ju ", // 0x0c
        "Lai ", // 0x0d
        "Qi ", // 0x0e
        "Min ", // 0x0f
        "Kun ", // 0x10
        "Kun ", // 0x11
        "Zu ", // 0x12
        "Gu ", // 0x13
        "Cui ", // 0x14
        "Ya ", // 0x15
        "Ya ", // 0x16
        "Gang ", // 0x17
        "Lun ", // 0x18
        "Lun ", // 0x19
        "Leng ", // 0x1a
        "Jue ", // 0x1b
        "Duo ", // 0x1c
        "Zheng ", // 0x1d
        "Guo ", // 0x1e
        "Yin ", // 0x1f
        "Dong ", // 0x20
        "Han ", // 0x21
        "Zheng ", // 0x22
        "Wei ", // 0x23
        "Yao ", // 0x24
        "Pi ", // 0x25
        "Yan ", // 0x26
        "Song ", // 0x27
        "Jie ", // 0x28
        "Beng ", // 0x29
        "Zu ", // 0x2a
        "Jue ", // 0x2b
        "Dong ", // 0x2c
        "Zhan ", // 0x2d
        "Gu ", // 0x2e
        "Yin ", // 0x2f
        "[?] ", // 0x30
        "Ze ", // 0x31
        "Huang ", // 0x32
        "Yu ", // 0x33
        "Wei ", // 0x34
        "Yang ", // 0x35
        "Feng ", // 0x36
        "Qiu ", // 0x37
        "Dun ", // 0x38
        "Ti ", // 0x39
        "Yi ", // 0x3a
        "Zhi ", // 0x3b
        "Shi ", // 0x3c
        "Zai ", // 0x3d
        "Yao ", // 0x3e
        "E ", // 0x3f
        "Zhu ", // 0x40
        "Kan ", // 0x41
        "Lu ", // 0x42
        "Yan ", // 0x43
        "Mei ", // 0x44
        "Gan ", // 0x45
        "Ji ", // 0x46
        "Ji ", // 0x47
        "Huan ", // 0x48
        "Ting ", // 0x49
        "Sheng ", // 0x4a
        "Mei ", // 0x4b
        "Qian ", // 0x4c
        "Wu ", // 0x4d
        "Yu ", // 0x4e
        "Zong ", // 0x4f
        "Lan ", // 0x50
        "Jue ", // 0x51
        "Yan ", // 0x52
        "Yan ", // 0x53
        "Wei ", // 0x54
        "Zong ", // 0x55
        "Cha ", // 0x56
        "Sui ", // 0x57
        "Rong ", // 0x58
        "Yamashina ", // 0x59
        "Qin ", // 0x5a
        "Yu ", // 0x5b
        "Kewashii ", // 0x5c
        "Lou ", // 0x5d
        "Tu ", // 0x5e
        "Dui ", // 0x5f
        "Xi ", // 0x60
        "Weng ", // 0x61
        "Cang ", // 0x62
        "Dang ", // 0x63
        "Hong ", // 0x64
        "Jie ", // 0x65
        "Ai ", // 0x66
        "Liu ", // 0x67
        "Wu ", // 0x68
        "Song ", // 0x69
        "Qiao ", // 0x6a
        "Zi ", // 0x6b
        "Wei ", // 0x6c
        "Beng ", // 0x6d
        "Dian ", // 0x6e
        "Cuo ", // 0x6f
        "Qian ", // 0x70
        "Yong ", // 0x71
        "Nie ", // 0x72
        "Cuo ", // 0x73
        "Ji ", // 0x74
        "[?] ", // 0x75
        "Tao ", // 0x76
        "Song ", // 0x77
        "Zong ", // 0x78
        "Jiang ", // 0x79
        "Liao ", // 0x7a
        "Kang ", // 0x7b
        "Chan ", // 0x7c
        "Die ", // 0x7d
        "Cen ", // 0x7e
        "Ding ", // 0x7f
        "Tu ", // 0x80
        "Lou ", // 0x81
        "Zhang ", // 0x82
        "Zhan ", // 0x83
        "Zhan ", // 0x84
        "Ao ", // 0x85
        "Cao ", // 0x86
        "Qu ", // 0x87
        "Qiang ", // 0x88
        "Zui ", // 0x89
        "Zui ", // 0x8a
        "Dao ", // 0x8b
        "Dao ", // 0x8c
        "Xi ", // 0x8d
        "Yu ", // 0x8e
        "Bo ", // 0x8f
        "Long ", // 0x90
        "Xiang ", // 0x91
        "Ceng ", // 0x92
        "Bo ", // 0x93
        "Qin ", // 0x94
        "Jiao ", // 0x95
        "Yan ", // 0x96
        "Lao ", // 0x97
        "Zhan ", // 0x98
        "Lin ", // 0x99
        "Liao ", // 0x9a
        "Liao ", // 0x9b
        "Jin ", // 0x9c
        "Deng ", // 0x9d
        "Duo ", // 0x9e
        "Zun ", // 0x9f
        "Jiao ", // 0xa0
        "Gui ", // 0xa1
        "Yao ", // 0xa2
        "Qiao ", // 0xa3
        "Yao ", // 0xa4
        "Jue ", // 0xa5
        "Zhan ", // 0xa6
        "Yi ", // 0xa7
        "Xue ", // 0xa8
        "Nao ", // 0xa9
        "Ye ", // 0xaa
        "Ye ", // 0xab
        "Yi ", // 0xac
        "E ", // 0xad
        "Xian ", // 0xae
        "Ji ", // 0xaf
        "Xie ", // 0xb0
        "Ke ", // 0xb1
        "Xi ", // 0xb2
        "Di ", // 0xb3
        "Ao ", // 0xb4
        "Zui ", // 0xb5
        "[?] ", // 0xb6
        "Ni ", // 0xb7
        "Rong ", // 0xb8
        "Dao ", // 0xb9
        "Ling ", // 0xba
        "Za ", // 0xbb
        "Yu ", // 0xbc
        "Yue ", // 0xbd
        "Yin ", // 0xbe
        "[?] ", // 0xbf
        "Jie ", // 0xc0
        "Li ", // 0xc1
        "Sui ", // 0xc2
        "Long ", // 0xc3
        "Long ", // 0xc4
        "Dian ", // 0xc5
        "Ying ", // 0xc6
        "Xi ", // 0xc7
        "Ju ", // 0xc8
        "Chan ", // 0xc9
        "Ying ", // 0xca
        "Kui ", // 0xcb
        "Yan ", // 0xcc
        "Wei ", // 0xcd
        "Nao ", // 0xce
        "Quan ", // 0xcf
        "Chao ", // 0xd0
        "Cuan ", // 0xd1
        "Luan ", // 0xd2
        "Dian ", // 0xd3
        "Dian ", // 0xd4
        "[?] ", // 0xd5
        "Yan ", // 0xd6
        "Yan ", // 0xd7
        "Yan ", // 0xd8
        "Nao ", // 0xd9
        "Yan ", // 0xda
        "Chuan ", // 0xdb
        "Gui ", // 0xdc
        "Chuan ", // 0xdd
        "Zhou ", // 0xde
        "Huang ", // 0xdf
        "Jing ", // 0xe0
        "Xun ", // 0xe1
        "Chao ", // 0xe2
        "Chao ", // 0xe3
        "Lie ", // 0xe4
        "Gong ", // 0xe5
        "Zuo ", // 0xe6
        "Qiao ", // 0xe7
        "Ju ", // 0xe8
        "Gong ", // 0xe9
        "Kek ", // 0xea
        "Wu ", // 0xeb
        "Pwu ", // 0xec
        "Pwu ", // 0xed
        "Chai ", // 0xee
        "Qiu ", // 0xef
        "Qiu ", // 0xf0
        "Ji ", // 0xf1
        "Yi ", // 0xf2
        "Si ", // 0xf3
        "Ba ", // 0xf4
        "Zhi ", // 0xf5
        "Zhao ", // 0xf6
        "Xiang ", // 0xf7
        "Yi ", // 0xf8
        "Jin ", // 0xf9
        "Xun ", // 0xfa
        "Juan ", // 0xfb
        "Phas ", // 0xfc
        "Xun ", // 0xfd
        "Jin ", // 0xfe
        "Fu " // 0xff
    };
}
