/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import java.time.Duration;
import java.util.Properties;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientConstants {
    static final String END_POINT_FORMAT = "amqps://%s.servicebus.windows.net";
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ClientConstants.class);
    public static final String FATAL_MARKER = "FATAL";
    public static final String PRODUCT_NAME = "MSJavaClient";
    public static final String CURRENT_JAVACLIENT_VERSION = ClientConstants.getClientVersion();
    public static final String PLATFORM_INFO = ClientConstants.getPlatformInfo();
    public static final int DEFAULT_OPERATION_TIMEOUT_IN_SECONDS = 30;
    public static final int LOCKTOKENSIZE = 16;
    public static final String ENQUEUEDTIMEUTCNAME = "x-opt-enqueued-time";
    public static final String SCHEDULEDENQUEUETIMENAME = "x-opt-scheduled-enqueue-time";
    public static final String SEQUENCENUBMERNAME = "x-opt-sequence-number";
    public static final String LOCKEDUNTILNAME = "x-opt-locked-until";
    public static final String PARTITIONKEYNAME = "x-opt-partition-key";
    public static final String DEADLETTERSOURCENAME = "x-opt-deadletter-source";
    public static final UUID ZEROLOCKTOKEN = new UUID(0L, 0L);
    public static final int AMQPS_PORT = 5671;
    public static final int MAX_PARTITION_KEY_LENGTH = 128;
    public static final Symbol SERVER_BUSY_ERROR = Symbol.getSymbol((String)"com.microsoft:server-busy");
    public static final Symbol ARGUMENT_ERROR = Symbol.getSymbol((String)"com.microsoft:argument-error");
    public static final Symbol ARGUMENT_OUT_OF_RANGE_ERROR = Symbol.getSymbol((String)"com.microsoft:argument-out-of-range");
    public static final Symbol ENTITY_DISABLED_ERROR = Symbol.getSymbol((String)"com.microsoft:entity-disabled");
    public static final Symbol PARTITION_NOT_OWNED_ERROR = Symbol.getSymbol((String)"com.microsoft:partition-not-owned");
    public static final Symbol STORE_LOCK_LOST_ERROR = Symbol.getSymbol((String)"com.microsoft:store-lock-lost");
    public static final Symbol PUBLISHER_REVOKED_ERROR = Symbol.getSymbol((String)"com.microsoft:publisher-revoked");
    public static final Symbol TIMEOUT_ERROR = Symbol.getSymbol((String)"com.microsoft:timeout");
    public static final Symbol LINK_TIMEOUT_PROPERTY = Symbol.getSymbol((String)"com.microsoft:timeout");
    public static final Symbol LINK_PEEKMODE_PROPERTY = Symbol.getSymbol((String)"com.microsoft:peek-mode");
    public static final Symbol TRACKING_ID_PROPERTY = Symbol.getSymbol((String)"com.microsoft:tracking-id");
    public static final Symbol DEADLETTERNAME = Symbol.valueOf((String)"com.microsoft:dead-letter");
    public static final Symbol MESSAGE_LOCK_LOST_ERROR = Symbol.getSymbol((String)"com.microsoft:message-lock-lost");
    public static final Symbol SESSION_LOCK_LOST_ERROR = Symbol.getSymbol((String)"com.microsoft:session-lock-lost");
    public static final Symbol SESSIONS_CANNOT_BE_LOCKED_ERROR = Symbol.getSymbol((String)"com.microsoft:session-cannot-be-locked");
    public static final Symbol MESSAGE_NOT_FOUND_ERROR = Symbol.getSymbol((String)"com.microsoft:message-not-found");
    public static final Symbol SESSION_NOT_FOUND_ERROR = Symbol.getSymbol((String)"com.microsoft:session-not-found");
    public static final Symbol ENTITY_ALREADY_EXISTS_ERROR = Symbol.getSymbol((String)"com.microsoft:entity-already-exists");
    public static final Symbol SESSION_FILTER = Symbol.getSymbol((String)"com.microsoft:session-filter");
    public static final Symbol LOCKED_UNTIL_UTC = Symbol.getSymbol((String)"com.microsoft:locked-until-utc");
    public static final String DEADLETTER_REASON_HEADER = "DeadLetterReason";
    public static final String DEADLETTER_ERROR_DESCRIPTION_HEADER = "DeadLetterErrorDescription";
    public static final int MAX_MESSAGE_LENGTH_BYTES = 262144;
    public static final int MAX_FRAME_SIZE_BYTES = 65536;
    public static final int MAX_EVENTHUB_AMQP_HEADER_SIZE_BYTES = 512;
    public static final Duration TIMER_TOLERANCE = Duration.ofSeconds(1L);
    public static final Duration DEFAULT_RERTRY_MIN_BACKOFF = Duration.ofSeconds(0L);
    public static final Duration DEFAULT_RERTRY_MAX_BACKOFF = Duration.ofSeconds(30L);
    public static final int DEFAULT_MAX_RETRY_COUNT = 10;
    public static final boolean DEFAULT_IS_TRANSIENT = true;
    public static final int REACTOR_IO_POLL_TIMEOUT = 20;
    public static final int SERVER_BUSY_BASE_SLEEP_TIME_IN_SECS = 4;
    public static final String NO_RETRY = "NoRetry";
    public static final String DEFAULT_RETRY = "Default";
    public static final String REQUEST_RESPONSE_OPERATION_NAME = "operation";
    public static final String REQUEST_RESPONSE_TIMEOUT = "com.microsoft:server-timeout";
    public static final String REQUEST_RESPONSE_RENEWLOCK_OPERATION = "com.microsoft:renew-lock";
    public static final String REQUEST_RESPONSE_RENEW_SESSIONLOCK_OPERATION = "com.microsoft:renew-session-lock";
    public static final String REQUEST_RESPONSE_RECEIVE_BY_SEQUENCE_NUMBER = "com.microsoft:receive-by-sequence-number";
    public static final String REQUEST_RESPONSE_SCHEDULE_MESSAGE_OPERATION = "com.microsoft:schedule-message";
    public static final String REQUEST_RESPONSE_CANCEL_CHEDULE_MESSAGE_OPERATION = "com.microsoft:cancel-scheduled-message";
    public static final String REQUEST_RESPONSE_PEEK_OPERATION = "com.microsoft:peek-message";
    public static final String REQUEST_RESPONSE_UPDATE_DISPOSTION_OPERATION = "com.microsoft:update-disposition";
    public static final String REQUEST_RESPONSE_GET_SESSION_STATE_OPERATION = "com.microsoft:get-session-state";
    public static final String REQUEST_RESPONSE_SET_SESSION_STATE_OPERATION = "com.microsoft:set-session-state";
    public static final String REQUEST_RESPONSE_GET_MESSAGE_SESSIONS_OPERATION = "com.microsoft:get-message-sessions";
    public static final String REQUEST_RESPONSE_ADD_RULE_OPERATION = "com.microsoft:add-rule";
    public static final String REQUEST_RESPONSE_REMOVE_RULE_OPERATION = "com.microsoft:remove-rule";
    public static final String REQUEST_RESPONSE_GET_RULES_OPERATION = "com.microsoft:enumerate-rules";
    public static final String REQUEST_RESPONSE_PUT_TOKEN_OPERATION = "put-token";
    public static final String REQUEST_RESPONSE_PUT_TOKEN_TYPE = "type";
    public static final String REQUEST_RESPONSE_PUT_TOKEN_AUDIENCE = "name";
    public static final String REQUEST_RESPONSE_PUT_TOKEN_EXPIRATION = "expiration";
    public static final String REQUEST_RESPONSE_LOCKTOKENS = "lock-tokens";
    public static final String REQUEST_RESPONSE_LOCKTOKEN = "lock-token";
    public static final String REQUEST_RESPONSE_EXPIRATION = "expiration";
    public static final String REQUEST_RESPONSE_EXPIRATIONS = "expirations";
    public static final String REQUEST_RESPONSE_SESSIONID = "session-id";
    public static final String REQUEST_RESPONSE_SESSION_STATE = "session-state";
    public static final String REQUEST_RESPONSE_SEQUENCE_NUMBERS = "sequence-numbers";
    public static final String REQUEST_RESPONSE_RECEIVER_SETTLE_MODE = "receiver-settle-mode";
    public static final String REQUEST_RESPONSE_MESSAGES = "messages";
    public static final String REQUEST_RESPONSE_MESSAGE = "message";
    public static final String REQUEST_RESPONSE_MESSAGE_ID = "message-id";
    public static final String REQUEST_RESPONSE_SESSION_ID = "session-id";
    public static final String REQUEST_RESPONSE_PARTITION_KEY = "partition-key";
    public static final String REQUEST_RESPONSE_FROM_SEQUENCE_NUMER = "from-sequence-number";
    public static final String REQUEST_RESPONSE_MESSAGE_COUNT = "message-count";
    public static final String REQUEST_RESPONSE_STATUS_CODE = "statusCode";
    public static final String REQUEST_RESPONSE_STATUS_DESCRIPTION = "statusDescription";
    public static final String REQUEST_RESPONSE_ERROR_CONDITION = "errorCondition";
    public static final String REQUEST_RESPONSE_ASSOCIATED_LINK_NAME = "associated-link-name";
    public static final String REQUEST_RESPONSE_LEGACY_STATUS_CODE = "status-code";
    public static final String REQUEST_RESPONSE_LEGACY_STATUS_DESCRIPTION = "status-description";
    public static final String REQUEST_RESPONSE_LEGACY_ERROR_CONDITION = "error-condition";
    public static final String REQUEST_RESPONSE_DISPOSITION_STATUS = "disposition-status";
    public static final String REQUEST_RESPONSE_DEADLETTER_REASON = "deadletter-reason";
    public static final String REQUEST_RESPONSE_DEADLETTER_DESCRIPTION = "deadletter-description";
    public static final String REQUEST_RESPONSE_PROPERTIES_TO_MODIFY = "properties-to-modify";
    public static final String REQUEST_RESPONSE_LAST_UPDATED_TIME = "last-updated-time";
    public static final String REQUEST_RESPONSE_LAST_SESSION_ID = "last-session-id";
    public static final String REQUEST_RESPONSE_SKIP = "skip";
    public static final String REQUEST_RESPONSE_TOP = "top";
    public static final String REQUEST_RESPONSE_SESSIONIDS = "sessions-ids";
    public static final String REQUEST_RESPONSE_RULES = "rules";
    public static final String REQUEST_RESPONSE_RULENAME = "rule-name";
    public static final String REQUEST_RESPONSE_RULEDESCRIPTION = "rule-description";
    public static final String REQUEST_RESPONSE_SQLFILTER = "sql-filter";
    public static final String REQUEST_RESPONSE_SQLRULEACTION = "sql-rule-action";
    public static final String REQUEST_RESPONSE_EXPRESSION = "expression";
    public static final String REQUEST_RESPONSE_CORRELATION_FILTER = "correlation-filter";
    public static final String REQUEST_RESPONSE_CORRELATION_ID = "correlation-id";
    public static final String REQUEST_RESPONSE_TO = "to";
    public static final String REQUEST_RESPONSE_REPLY_TO = "reply-to";
    public static final String REQUEST_RESPONSE_LABEL = "label";
    public static final String REQUEST_RESPONSE_REPLY_TO_SESSION_ID = "reply-to-session-id";
    public static final String REQUEST_RESPONSE_CONTENT_TYPE = "content-type";
    public static final String REQUEST_RESPONSE_CORRELATION_FILTER_PROPERTIES = "properties";
    public static final String DISPOSITION_STATUS_COMPLETED = "completed";
    public static final String DISPOSITION_STATUS_DEFERED = "defered";
    public static final String DISPOSITION_STATUS_SUSPENDED = "suspended";
    public static final String DISPOSITION_STATUS_ABANDONED = "abandoned";
    public static final int REQUEST_RESPONSE_OK_STATUS_CODE = 200;
    public static final int REQUEST_RESPONSE_ACCEPTED_STATUS_CODE = 202;
    public static final int REQUEST_RESPONSE_NOCONTENT_STATUS_CODE = 204;
    public static final int REQUEST_RESPONSE_NOTFOUND_STATUS_CODE = 404;
    public static final int REQUEST_RESPONSE_UNDEFINED_STATUS_CODE = -1;
    public static final int REQUEST_RESPONSE_SERVER_BUSY_STATUS_CODE = 503;
    public static final UnsignedLong RULE_DESCRIPTION_DESCRIPTOR = new UnsignedLong(1335734829060L);
    public static final UnsignedLong EMPTY_RULE_ACTION_DESCRIPTOR = new UnsignedLong(1335734829061L);
    public static final UnsignedLong SQL_RULE_ACTION_DESCRIPTOR = new UnsignedLong(1335734829062L);
    public static final UnsignedLong SQL_FILTER_DESCRIPTOR = new UnsignedLong(83483426822L);
    public static final UnsignedLong TRUE_FILTER_DESCRIPTOR = new UnsignedLong(83483426823L);
    public static final UnsignedLong FALSE_FILTER_DESCRIPTOR = new UnsignedLong(83483426824L);
    public static final UnsignedLong CORRELATION_FILTER_DESCRIPTOR = new UnsignedLong(83483426825L);
    static final int DEFAULT_SAS_TOKEN_SEND_RETRY_INTERVAL_IN_SECONDS = 5;
    static final String SAS_TOKEN_AUDIENCE_FORMAT = "amqp://%s/%s";

    private ClientConstants() {
    }

    private static String getClientVersion() {
        String clientVersion;
        Properties properties = new Properties();
        try {
            properties.load(ClientConstants.class.getResourceAsStream("/client.properties"));
            clientVersion = properties.getProperty("client.version");
        }
        catch (Exception e) {
            clientVersion = "NOTFOUND";
            TRACE_LOGGER.error("Exception while retrieving client version. Exception: ", (Object)e.toString());
        }
        return clientVersion;
    }

    private static String getPlatformInfo() {
        Package javaRuntimeClassPkg = Runtime.class.getPackage();
        StringBuilder patformInfo = new StringBuilder();
        patformInfo.append("jre:");
        patformInfo.append(javaRuntimeClassPkg.getImplementationVersion());
        patformInfo.append(";vendor:");
        patformInfo.append(javaRuntimeClassPkg.getImplementationVendor());
        patformInfo.append(";jvm:");
        patformInfo.append(System.getProperty("java.vm.version"));
        patformInfo.append(";arch:");
        patformInfo.append(System.getProperty("os.arch"));
        patformInfo.append(";os:");
        patformInfo.append(System.getProperty("os.name"));
        patformInfo.append(";os version:");
        patformInfo.append(System.getProperty("os.version"));
        return patformInfo.toString();
    }
}

