/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.tasks;

import com.jurismarches.vradi.beans.XmlStreamImportResult;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.BindingManager;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;

public class ImportXmlStreamTasks
extends TimerTask {
    private static final Log log = LogFactory.getLog(ImportXmlStreamTasks.class);
    protected WikittyProxy wikittyProxy;
    protected BindingManager bindingManager;
    protected String xmlStreamId;

    public ImportXmlStreamTasks(WikittyProxy wikittyProxy, BindingManager bindingManager, String xmlStreamId) {
        this.wikittyProxy = wikittyProxy;
        this.bindingManager = bindingManager;
        this.xmlStreamId = xmlStreamId;
    }

    @Override
    public void run() {
        block4: {
            try {
                XmlStream xmlStream = (XmlStream)this.wikittyProxy.restore(XmlStream.class, this.xmlStreamId);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Starting xml stream import on : " + xmlStream.getName() + "..."));
                }
                XmlStreamImportResult importResult = this.bindingManager.importFormsFromXmlStream(xmlStream);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Xml stream " + xmlStream.getName() + " imported : " + importResult.getCreatedFormCount() + " new forms."));
                }
            }
            catch (VradiException ex) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Can't import forms from stream " + this.xmlStreamId), (Throwable)ex);
            }
        }
    }
}

