/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.ooo;

import com.jurismarches.vradi.services.ooo.OOoServer;
import com.sun.star.bridge.UnoUrlResolver;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;

public class BootstrapConnector {
    private OOoServer oooServer;
    private String oooConnectionString;

    public BootstrapConnector(String oooExecFolder) {
        this.oooServer = new OOoServer(oooExecFolder);
        this.oooConnectionString = null;
    }

    public BootstrapConnector(OOoServer oooServer) {
        this.oooServer = oooServer;
        this.oooConnectionString = null;
    }

    public XComponentContext connect(String oooAcceptOption, String oooConnectionString) throws BootstrapException {
        this.oooConnectionString = oooConnectionString;
        XComponentContext xContext = null;
        try {
            XComponentContext xLocalContext = this.getLocalContext();
            this.oooServer.start(oooAcceptOption);
            XMultiComponentFactory xLocalServiceManager = xLocalContext.getServiceManager();
            if (xLocalServiceManager == null) {
                throw new BootstrapException("no initial service manager!");
            }
            XUnoUrlResolver xUrlResolver = UnoUrlResolver.create((XComponentContext)xLocalContext);
            int i = 0;
            while (true) {
                try {
                    xContext = this.getRemoteContext(xUrlResolver);
                }
                catch (NoConnectException ex) {
                    if (i == 600) {
                        throw new BootstrapException(ex.toString());
                    }
                    Thread.sleep(500L);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BootstrapException(e);
        }
        return xContext;
    }

    public void disconnect() {
        if (this.oooConnectionString == null) {
            return;
        }
        try {
            XComponentContext xLocalContext = this.getLocalContext();
            XUnoUrlResolver xUrlResolver = UnoUrlResolver.create((XComponentContext)xLocalContext);
            XComponentContext xRemoteContext = this.getRemoteContext(xUrlResolver);
            Object desktop = xRemoteContext.getServiceManager().createInstanceWithContext("com.sun.star.frame.Desktop", xRemoteContext);
            XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
            xDesktop.terminate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.oooServer.kill();
        this.oooConnectionString = null;
    }

    private XComponentContext getLocalContext() throws BootstrapException, Exception {
        XComponentContext xLocalContext = Bootstrap.createInitialComponentContext(null);
        if (xLocalContext == null) {
            throw new BootstrapException("no local component context!");
        }
        return xLocalContext;
    }

    private XComponentContext getRemoteContext(XUnoUrlResolver xUrlResolver) throws BootstrapException, ConnectionSetupException, IllegalArgumentException, NoConnectException {
        Object context = xUrlResolver.resolve(this.oooConnectionString);
        XComponentContext xContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)context);
        if (xContext == null) {
            throw new BootstrapException("no component context!");
        }
        return xContext;
    }

    public static final XComponentContext bootstrap(String oooExecFolder, String oooAcceptOption, String oooConnectionString) throws BootstrapException {
        BootstrapConnector bootstrapConnector = new BootstrapConnector(oooExecFolder);
        return bootstrapConnector.connect(oooAcceptOption, oooConnectionString);
    }
}

