/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.beans.ThesaurusCartography;
import com.jurismarches.vradi.entities.EntityHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import com.jurismarches.vradi.services.search.CompareFilter;
import com.jurismarches.vradi.services.search.Filter;
import com.jurismarches.vradi.services.search.FilterList;
import com.jurismarches.vradi.services.search.RangeFilter;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import com.jurismarches.vradi.services.search.VradiQueryParser;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.DateUtils;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FacetTopic;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Like;
import org.nuiton.wikitty.search.Search;

public class SearchManager {
    private static final Log log = LogFactory.getLog(SearchManager.class);
    private final WikittyProxy proxy;
    private final ThesaurusManager thesaurusManager;
    private static final DateFormat frenchDateFormat = DateFormat.getDateInstance(3, Locale.FRANCE);
    private static final DateFormat numericDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.FRANCE);
    private static final Pattern frenchDateFormatPattern = Pattern.compile("^(3[01]|[12][0-9]|0[1-9])/(1[0-2]|0[1-9])/[0-9]{4}$");
    private static final Pattern numericDateFormatPattern = Pattern.compile("^[0-9]{4}(1[0-2]|0[1-9])(3[01]|[12][0-9]|0[1-9])$");
    private static final Pattern uuidPattern = Pattern.compile("^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$");
    private static final Pattern formIdPattern = Pattern.compile("^[0-9]{4}-(1[0-2]|0[1-9])-(3[01]|[12][0-9]|0[1-9])([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})$");
    public static final String ALIAS_LAST_MODIFIER = "modificateur";
    public static final String ALIAS_LAST_STATUS_MODIFIER = "modificateur.status";

    public SearchManager(WikittyProxy proxy, ThesaurusManager thesaurusManager) {
        this.proxy = proxy;
        this.thesaurusManager = thesaurusManager;
    }

    public FormPagedResult findForms(String query, FormPagedResult formPagedResult, String dateType, Date fromDate, String statusId) throws UnsupportedQueryException, VradiException {
        return this.findForms(query, null, dateType, fromDate, new Date(), null, null, new String[]{statusId}, formPagedResult);
    }

    public FormPagedResult findForms(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, String streamId, List<String> thesaurus, String[] statusIds, FormPagedResult formPagedResult) throws UnsupportedQueryException, VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.format("findForms(query:%s, extension:%s, dateType:%s, beginDate:%tc, endDate:%tc)", query, extension, dateType, beginDate, endDate) + " status : " + statusIds));
        }
        Search search = this.createSearch(query, extension, dateType, beginDate, endDate, streamId, thesaurus, statusIds);
        Criteria criteria = search.criteria();
        int firstIndex = (formPagedResult.getPageToShow() - 1) * formPagedResult.getNbFormsToShow();
        int lastIndex = formPagedResult.getPageToShow() * formPagedResult.getNbFormsToShow() - 1;
        if (firstIndex >= 0 && lastIndex > 0 && lastIndex > firstIndex) {
            criteria.setFirstIndex(firstIndex).setEndIndex(lastIndex);
        }
        if (formPagedResult.getFieldToSort() != null) {
            if (!formPagedResult.isAscending()) {
                criteria.addSortDescending(formPagedResult.getFieldToSort());
            } else {
                criteria.addSortAscending(formPagedResult.getFieldToSort());
            }
        }
        criteria.addSortAscending("Infogene.id");
        PagedResult queryResult = this.proxy.findAllByCriteria(Form.class, criteria);
        ArrayList<Form> result = new ArrayList<Form>(queryResult.getAll());
        if (log.isDebugEnabled()) {
            log.debug((Object)("[findForms] found: " + result.size() + " forms"));
        }
        FormPagedResult formPageResult = new FormPagedResult(result, queryResult.getNumFound(), formPagedResult.getPageToShow(), formPagedResult.getNbFormsToShow());
        return formPageResult;
    }

    public ThesaurusCartography getThesaurusCartography(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, String streamId, List<String> thesaurusIds, String[] statusIds) throws VradiException, UnsupportedQueryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getThesaurusCartography()");
        }
        HashMap<String, Integer> cartography = new HashMap<String, Integer>();
        List<Thesaurus> thesauruses = this.thesaurusManager.getAllThesaurus();
        Search search = this.createSearch(query, extension, dateType, beginDate, endDate, streamId, thesaurusIds, statusIds);
        Criteria criteria = search.criteria();
        for (Thesaurus thesaurus : thesauruses) {
            String facetField = "TreeNode." + thesaurus.getWikittyId();
            criteria.addFacetField(facetField);
            cartography.put(thesaurus.getWikittyId(), 0);
        }
        PagedResult results = this.proxy.findAllByCriteria(Form.class, criteria);
        Collection facetNames = results.getFacetNames();
        if (log.isDebugEnabled()) {
            log.debug((Object)("FacetName size " + facetNames.size()));
        }
        for (String facetName : facetNames) {
            List topics = results.getTopic(facetName);
            if (log.isDebugEnabled() && topics.size() > 0) {
                log.debug((Object)("FacetName " + facetName + " topic size " + topics.size()));
            }
            for (FacetTopic topic : topics) {
                Thesaurus thesaurus;
                if (log.isDebugEnabled() && topic.getCount() > 0) {
                    log.debug((Object)("FacetTopic name " + topic.getTopicName() + " count " + topic.getCount()));
                }
                if ((thesaurus = (Thesaurus)this.proxy.restore(Thesaurus.class, topic.getTopicName())) == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Thesaurus not found for id : " + topic.getTopicName()));
                    continue;
                }
                cartography.put(thesaurus.getWikittyId(), topic.getCount());
            }
        }
        List formsFounds = results.getAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating cartography with : " + formsFounds.size() + " forms founds and " + cartography.size() + " thesaurus concerned"));
        }
        ThesaurusCartography thesaurusCartography = new ThesaurusCartography(cartography, formsFounds);
        return thesaurusCartography;
    }

    public Map<QueryMaker, List<QueryBean>> findQueriesReturningForm(Form form) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findQueriesReturningForm(form)");
        }
        HashMap<QueryMaker, List<QueryBean>> results = new HashMap<QueryMaker, List<QueryBean>>();
        if (form == null) {
            return results;
        }
        List<QueryMaker> queryMakers = this.findQueryMakersWithQueries();
        for (QueryMaker queryMaker : queryMakers) {
            QueryMaker realQueryMaker;
            Set queries = queryMaker.getQueries();
            if (queries == null || queries.isEmpty() || (realQueryMaker = EntityHelper.castAsRealQueryMaker((QueryMaker)queryMaker)) == null) continue;
            for (String query : queries) {
                try {
                    QueryBean bean = new QueryBean(query, queryMaker.getWikittyId());
                    String realQuery = bean.getQuery();
                    FilterList filter = VradiQueryParser.parse(realQuery);
                    Search search = Search.query();
                    search.eq("Infogene.id", form.getId());
                    this.buildSearch(filter, search);
                    Criteria criteria = search.criteria();
                    PagedResult forms = this.proxy.findAllByCriteria(Form.class, criteria);
                    if (forms.getNumFound() <= 0) continue;
                    if (results.containsKey(realQueryMaker)) {
                        ((List)results.get(realQueryMaker)).add(bean);
                        continue;
                    }
                    ArrayList<QueryBean> list = new ArrayList<QueryBean>();
                    list.add(bean);
                    results.put(realQueryMaker, list);
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return results;
    }

    public List<QueryMaker> findQueryMakersWithQueries() {
        Criteria criteria = Search.query().bw("QueryMaker.queries", "*", "*").criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(QueryMaker.class, criteria);
        List all = pagedResult.getAll();
        return all;
    }

    public List<Group> findGroupsWithQueries() {
        Criteria criteria = Search.query().bw("QueryMaker.queries", "*", "*").criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(Group.class, criteria);
        List all = pagedResult.getAll();
        return all;
    }

    protected Search createSearch(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, String streamId, Collection<String> thesaurusIds, String[] statusIds) throws UnsupportedQueryException, VradiException {
        FilterList filter = VradiQueryParser.parse(query);
        Search search = Search.query();
        this.buildSearch(filter, search);
        if (extension != null) {
            search.eq(Element.ELT_EXTENSION, extension.getName());
        }
        if (dateType != null && beginDate != null && endDate != null) {
            String beginString = null;
            String endString = null;
            try {
                beginString = WikittyUtil.formatDate((Date)beginDate);
                endString = WikittyUtil.formatDate((Date)endDate);
            }
            catch (ParseException eee) {
                throw new VradiException("Cant format date : ", eee);
            }
            search.bw(dateType, beginString, endString);
        }
        if (thesaurusIds != null) {
            for (String thesaurusId : thesaurusIds) {
                Search subSearch = search.or();
                subSearch.eq("Form.thesaurus", thesaurusId);
            }
        }
        if (!ArrayUtils.isEmpty((Object[])statusIds)) {
            Search subSearch = search.or();
            for (String statusId : statusIds) {
                subSearch.eq("Infogene.status", statusId);
            }
        }
        if (streamId != null) {
            search.eq("Form.xmlStream", streamId);
        }
        return search;
    }

    protected void buildSearch(FilterList list, Search search) throws VradiException {
        FilterList.Operator operator = list.getOperator();
        Search subSearch = null;
        switch (operator) {
            case FILTER_OR: {
                subSearch = search.or();
                break;
            }
            case FILTER_AND: {
                subSearch = search.and();
                break;
            }
            case FILTER_NOT: {
                subSearch = search.not();
            }
        }
        List<Filter> filters = list.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                this.buildSearch((FilterList)filter, subSearch);
                continue;
            }
            if (filter instanceof RangeFilter) {
                this.buildRangeSearch((RangeFilter)filter, subSearch);
                continue;
            }
            if (!(filter instanceof CompareFilter)) continue;
            this.buildCompareSearch(operator, (CompareFilter)filter, subSearch);
        }
    }

    protected void buildRangeSearch(RangeFilter rangeFilter, Search search) {
        String name = rangeFilter.getName();
        String lowerValue = rangeFilter.getLowerValue();
        String upperValue = rangeFilter.getUpperValue();
        Search subSearch = search.or();
        if (rangeFilter.match(numericDateFormatPattern)) {
            try {
                Date lowerTime = numericDateFormat.parse(lowerValue);
                lowerTime = DateUtils.setMinTimeOfDay((Date)lowerTime);
                String lowerTimeString = WikittyUtil.formatDate((Date)lowerTime);
                Date upperTime = numericDateFormat.parse(upperValue);
                upperTime = DateUtils.setMaxTimeOfDay((Date)upperTime);
                String upperTimeString = WikittyUtil.formatDate((Date)upperTime);
                subSearch.bw("*." + name + "." + Element.ElementType.DATE, lowerTimeString, upperTimeString);
            }
            catch (ParseException e) {
                log.warn((Object)(lowerValue + " OR " + upperValue + " cannot be a date."));
            }
        } else if (rangeFilter.isNumber()) {
            subSearch.bw("*." + name + "." + Element.ElementType.NUMERIC, lowerValue, upperValue);
        }
        subSearch.bw("*." + name + "." + Element.ElementType.STRING, lowerValue, upperValue);
    }

    protected void buildCompareSearch(FilterList.Operator operator, CompareFilter compareFilter, Search search) throws VradiException {
        Search subSearch;
        String value;
        String name;
        block22: {
            Date time;
            name = compareFilter.getName();
            value = compareFilter.getValue();
            if ("text".equals(name)) {
                search.keyword(value);
                return;
            }
            List<RootThesaurus> rootThesauruses = this.thesaurusManager.getRootThesaurus();
            for (RootThesaurus rootThesaurus : rootThesauruses) {
                if (!name.equalsIgnoreCase(rootThesaurus.getName())) continue;
                this.buildDescripteurSearch(search, rootThesaurus.getWikittyId(), value);
                return;
            }
            if (ALIAS_LAST_MODIFIER.equals(name)) {
                name = "lastModifier";
            } else if (ALIAS_LAST_STATUS_MODIFIER.equals(name)) {
                name = "lastStatusModifier";
            }
            subSearch = search.or();
            if (operator == FilterList.Operator.FILTER_NOT) {
                if (compareFilter.match(frenchDateFormatPattern)) {
                    try {
                        time = frenchDateFormat.parse(value);
                        String timeString = WikittyUtil.formatDate((Date)time);
                        subSearch.eq("*." + name + "." + Element.ElementType.DATE, timeString);
                    }
                    catch (ParseException e) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)(value + " cannot be a date."));
                        }
                    }
                }
            } else if (compareFilter.match(frenchDateFormatPattern)) {
                try {
                    time = frenchDateFormat.parse(value);
                    Date beginDate = DateUtils.setMinTimeOfDay((Date)time);
                    Date endDate = DateUtils.setMaxTimeOfDay((Date)time);
                    String beginString = WikittyUtil.formatDate((Date)beginDate);
                    String endString = WikittyUtil.formatDate((Date)endDate);
                    subSearch.bw("*." + name + "." + Element.ElementType.DATE, beginString, endString);
                }
                catch (ParseException e) {
                    if (!log.isWarnEnabled()) break block22;
                    log.warn((Object)(value + " cannot be a date."));
                }
            }
        }
        subSearch.eq("*." + name + "." + Element.ElementType.STRING, value);
        if (!compareFilter.isPhrase()) {
            subSearch.like("*." + name + "." + Element.ElementType.STRING, value, Like.SearchAs.AsText);
        }
        if (compareFilter.isBoolean()) {
            subSearch.eq("*." + name + "." + Element.ElementType.BOOLEAN, value);
        } else if (compareFilter.isNumber()) {
            subSearch.eq("*." + name + "." + Element.ElementType.NUMERIC, value);
        } else if (compareFilter.match(formIdPattern)) {
            subSearch.eq("*." + name + "." + Element.ElementType.STRING, value);
        } else if (compareFilter.match(uuidPattern)) {
            subSearch.ew("*." + name + "." + Element.ElementType.STRING, value);
        }
    }

    protected void buildDescripteurSearch(Search search, String rootThesaurusId, String value) {
        Criteria criteria = Search.query().eq("TreeNode.name", value).eq("Thesaurus.rootThesaurus", rootThesaurusId).eq(Element.ELT_EXTENSION, "Thesaurus").criteria();
        PagedResult queryResult = this.proxy.findAllByCriteria(Thesaurus.class, criteria);
        if (queryResult.getNumFound() > 0) {
            Search subSearch = search.or();
            List result = queryResult.getAll();
            for (Thesaurus thesaurus : result) {
                if (thesaurus.getParent() == null) {
                    subSearch.eq("TreeNode.root", thesaurus.getWikittyId());
                    continue;
                }
                subSearch.eq("TreeNode." + thesaurus.getParent(), thesaurus.getWikittyId());
            }
        }
    }
}

