/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.entities.RootThesaurusImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyExtensionMigration;
import org.nuiton.wikitty.WikittyExtensionMigrationRename;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class ServiceMigration {
    private static final Log log = LogFactory.getLog(ServiceMigration.class);

    public static void configureMigration() {
        ServiceMigration.configureMigration010();
    }

    protected static void configureMigration010() {
        WikittyExtensionMigration.migrationRegistry.put("VradiUser", new MigrationVradiUserWikittyUser());
    }

    public static void versionChangeMigration(String lastVersion, String currentVersion, WikittyProxy localWikittyProxy) {
        if ("0.0.5".equals(lastVersion) && "0.1.0".equals(currentVersion)) {
            Search search;
            Criteria criteria;
            TreeNodeImpl rootThesaurus;
            if (log.isInfoEnabled()) {
                log.info((Object)"Migration root Thesaurus node : add RootThesaurus extension");
            }
            if ((rootThesaurus = (TreeNodeImpl)localWikittyProxy.findByCriteria(TreeNodeImpl.class, criteria = (search = Search.query().eq(Element.ELT_EXTENSION, "TreeNode").eq("TreeNode.name", "Thesaurus")).criteria())) != null) {
                if (!rootThesaurus.getWikitty().hasExtension("RootThesaurus")) {
                    rootThesaurus.getWikitty().addExtension(RootThesaurusImpl.extensionRootThesaurus);
                    rootThesaurus.setName("Thesaurus");
                    localWikittyProxy.store((BusinessEntity)rootThesaurus);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"Set rootThesaurus id to all existing thesaurus");
                }
                search = Search.query().eq(Element.ELT_EXTENSION, "Thesaurus");
                criteria = search.criteria();
                List thesauruses = localWikittyProxy.findAllByCriteria(Thesaurus.class, criteria).getAll();
                for (Thesaurus thesaurus : thesauruses) {
                    thesaurus.setRootThesaurus(rootThesaurus.getWikittyId());
                }
                localWikittyProxy.store(thesauruses);
            }
            Criteria criteriaStatus = Search.query().eq(Element.ELT_EXTENSION, "Status").criteria();
            List statuses = localWikittyProxy.findAllByCriteria(Status.class, criteriaStatus).getAll();
            ArrayList<String> statusesIds = new ArrayList<String>();
            for (Status status : statuses) {
                statusesIds.add(status.getWikittyId());
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Deleting status " + status.getName()));
            }
            localWikittyProxy.delete(statusesIds);
        }
    }

    static class MigrationVradiUserWikittyUser
    extends WikittyExtensionMigrationRename {
        MigrationVradiUserWikittyUser() {
        }

        public Wikitty migrate(WikittyService service, WikittyTransaction transaction, Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt) {
            Set fqFieldNames;
            String wikittyId = wikitty.getId();
            String wikittyVersion = wikitty.getVersion();
            WikittyImpl result = new WikittyImpl(wikittyId);
            result.setVersion(wikittyVersion);
            for (WikittyExtension extension : wikitty.getExtensions()) {
                if (extension.equals((Object)oldExt)) {
                    this.addExtension(service, transaction, (Wikitty)result, newExt);
                    continue;
                }
                this.addExtension(service, transaction, (Wikitty)result, extension);
            }
            if (oldExt.getVersion().equals("1.0")) {
                fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value;
                    if (fieldName.equals("VradiUser.name")) {
                        value = wikitty.getFqField(fieldName);
                        result.setFqField("WikittyUser.login", value);
                        continue;
                    }
                    if (fieldName.equals("VradiUser.password")) {
                        value = wikitty.getFqField(fieldName);
                        result.setFqField("WikittyUser.password", value);
                        continue;
                    }
                    value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            } else {
                fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            }
            return result;
        }
    }
}

