/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class VradiServiceAction {
    private static final Log log = LogFactory.getLog(VradiServiceAction.class);

    public static void reIndexSolr() {
        log.info((Object)"Starting reIndex solr");
        long startingTime = System.nanoTime();
        WikittyService wikittyService = ServiceFactory.getWikittyService();
        String securityToken = ServiceFactory.getWikittyProxy().getSecurityToken();
        wikittyService.syncEngin(securityToken);
        log.info((Object)("ReIndex solr is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(1);
    }

    public static void deleteObseleteThesaurus() {
        Thesaurus thesaurus;
        log.info((Object)"Starting deleting obselete thesaurus");
        long startingTime = System.nanoTime();
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Thesaurus").criteria();
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        List thesauruses = proxy.findAllByCriteria(Thesaurus.class, criteria).getAll();
        Iterator i$ = thesauruses.iterator();
        while (i$.hasNext() && (thesaurus = (Thesaurus)i$.next()) != null) {
            String parentId = thesaurus.getParent();
            if (parentId == null) {
                proxy.delete(thesaurus.getWikittyId());
                log.info((Object)("Found thesaurus '" + thesaurus.getName() + "' has no parentId, deleting this"));
                continue;
            }
            Thesaurus parent = (Thesaurus)proxy.restore(Thesaurus.class, parentId);
            if (parent != null) continue;
            proxy.delete(thesaurus.getWikittyId());
            log.info((Object)("Found thesaurus '" + thesaurus.getName() + "' has no parent with id '" + parentId + ", deleting this"));
        }
        log.info((Object)("Deleting obselete thesaurus is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(1);
    }

    public static void reinitStatus() {
        log.info((Object)"Starting reinit status");
        long startingTime = System.nanoTime();
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Status").criteria();
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        List statuses = proxy.findAllByCriteria(Status.class, criteria).getAll();
        ArrayList<String> statusesIds = new ArrayList<String>();
        for (Status status : statuses) {
            statusesIds.add(status.getWikittyId());
            log.info((Object)("Deleting status " + status.getName()));
        }
        proxy.delete(statusesIds);
        try {
            ServiceFactory.getVradiStorageService().createDefaultStatuses();
        }
        catch (VradiException eee) {
            log.error((Object)eee);
        }
        log.info((Object)("reinit status is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(1);
    }

    public static void forceAllOldUserEnable() {
        User user;
        log.info((Object)"Starting forcing all user enabled");
        long startingTime = System.nanoTime();
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "User").criteria();
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        List users = proxy.findAllByCriteria(User.class, criteria).getAll();
        Iterator i$ = users.iterator();
        while (i$.hasNext() && (user = (User)i$.next()) != null) {
            Object field = user.getField("User", "enable");
            if (field != null) continue;
            log.info((Object)("Found user '" + user.getName() + "' with no enable"));
            user.setField("User", "enable", (Object)true);
            proxy.store((BusinessEntity)user);
        }
        log.info((Object)("Forcing all user enabled is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(1);
    }

    public static enum ActionDefinition {
        REINDEX_SOLR(VradiServiceAction.class.getName() + "#reIndexSolr", "--reIndexSolr"),
        DELETE_OBSELETE_THESAURUS(VradiServiceAction.class.getName() + "#deleteObseleteThesaurus", "--deleteObseleteThesaurus"),
        REINIT_STATUS(VradiServiceAction.class.getName() + "#reinitStatus", "--reinitStatus"),
        FORCE_ALL_OLD_USER_ENABLE(VradiServiceAction.class.getName() + "#forceAllOldUserEnable", "--forceAllOldUserEnable");

        public String action;
        public String[] aliases;

        private ActionDefinition(String action, String ... aliases) {
            this.action = action;
            this.aliases = aliases;
        }

        public String getAction() {
            return this.action;
        }

        public String[] getAliases() {
            return this.aliases;
        }
    }
}

