/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.QueryMakerImpl;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.dto.VradiCartographyDTO;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiQueryBean;
import com.jurismarches.vradi.services.managers.ClientManager;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import com.jurismarches.vradi.services.search.CompareFilter;
import com.jurismarches.vradi.services.search.Filter;
import com.jurismarches.vradi.services.search.FilterList;
import com.jurismarches.vradi.services.search.RangeFilter;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import com.jurismarches.vradi.services.search.VradiQueryParser;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.DateUtils;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FacetTopic;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyService;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Like;
import org.sharengo.wikitty.search.Search;

public class SearchManager {
    private static final Log log = LogFactory.getLog(SearchManager.class);
    private final WikittyProxy proxy;
    private final ThesaurusManager thesaurusManager;
    private static final DateFormat frenchDateFormat = DateFormat.getDateInstance(3, Locale.FRANCE);
    private static final DateFormat numericDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.FRANCE);
    private static final Pattern frenchDateFormatPattern = Pattern.compile("^(3[01]|[12][0-9]|0[1-9])/(1[0-2]|0[1-9])/[0-9]{4}$");
    private static final Pattern numericDateFormatPattern = Pattern.compile("^[0-9]{4}(1[0-2]|0[1-9])(3[01]|[12][0-9]|0[1-9])$");
    private static final Pattern uuidPattern = Pattern.compile("^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$");
    private static final Pattern formIdPattern = Pattern.compile("^[0-9]{4}-(1[0-2]|0[1-9])-(3[01]|[12][0-9]|0[1-9])([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})$");
    public static final String ALIAS_THESAURUS_1 = "thesaurus";
    public static final String ALIAS_THESAURUS_2 = "descripteurs";
    public static final String ALIAS_LAST_MODIFIER = "modificateur";
    public static final String ALIAS_LAST_STATUS_MODIFIER = "modificateur.status";

    public SearchManager(WikittyProxy proxy, ThesaurusManager thesaurusManager) {
        this.proxy = proxy;
        this.thesaurusManager = thesaurusManager;
    }

    public VradiFormPageDTO findForms(String query, VradiFormPageDTO formPageDTO) throws UnsupportedQueryException {
        return this.findForms(query, null, null, null, null, null, null, formPageDTO);
    }

    public VradiFormPageDTO findForms(String query, VradiFormPageDTO formPageDTO, Date fromDate, String statusId) throws UnsupportedQueryException {
        String[] statusIds = new String[]{statusId};
        return this.findForms(query, null, null, fromDate, new Date(), null, statusIds, formPageDTO);
    }

    public VradiFormPageDTO findForms(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, List<String>[] thesaurus, String[] statusIds, VradiFormPageDTO formPageDTO) throws UnsupportedQueryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("findForms(query:%s, extension:%s, dateType:%s, beginDate:%tc, endDate:%tc)", query, extension, dateType, beginDate, endDate));
        }
        Search search = this.createSearch(query, extension, dateType, beginDate, endDate, thesaurus, statusIds);
        Criteria criteria = search.criteria();
        int firstIndex = (formPageDTO.getPageToShow() - 1) * formPageDTO.getNbFormsToShow();
        int lastIndex = formPageDTO.getPageToShow() * formPageDTO.getNbFormsToShow() - 1;
        if (firstIndex >= 0 && lastIndex > 0 && lastIndex > firstIndex) {
            criteria.setFirstIndex(firstIndex).setEndIndex(lastIndex);
        }
        if (formPageDTO.getFieldToSort() != null) {
            if (!formPageDTO.isAscending()) {
                criteria.addSortDescending(formPageDTO.getFieldToSort());
            } else {
                criteria.addSortAscending(formPageDTO.getFieldToSort());
            }
        }
        criteria.addSortAscending("Infogene.id");
        PagedResult queryResult = this.proxy.findAllByCriteria(Form.class, criteria);
        ArrayList<Form> result = new ArrayList<Form>(queryResult.getAll());
        if (log.isTraceEnabled()) {
            for (Form form : result) {
                log.trace((Object)("found: " + form.toString()));
            }
        }
        VradiFormPageDTO formPageResult = new VradiFormPageDTO(result, queryResult.getNumFound(), formPageDTO.getPageToShow(), formPageDTO.getNbFormsToShow());
        return formPageResult;
    }

    public VradiCartographyDTO getThesaurusCartography(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, List<String>[] thesaurus, String[] statusIds) throws VradiException, UnsupportedQueryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getThesaurusCartography()");
        }
        HashMap<TreeNodeImpl, Integer> cartography = new HashMap<TreeNodeImpl, Integer>();
        HashMap<String, TreeNodeImpl> nodes = new HashMap<String, TreeNodeImpl>();
        List<TreeNodeImpl> treeNodes = this.thesaurusManager.getAllThesaurus();
        TreeNodeImpl rootThesaurus = this.thesaurusManager.getRootThesaurus();
        Search search = this.createSearch(query, extension, dateType, beginDate, endDate, thesaurus, statusIds);
        Criteria criteria = search.criteria();
        criteria.addFacetField("TreeNode." + rootThesaurus.getWikittyId());
        for (TreeNodeImpl treeNode : treeNodes) {
            criteria.addFacetField("TreeNode." + treeNode.getWikittyId());
            cartography.put(treeNode, 0);
            nodes.put(treeNode.getWikittyId(), treeNode);
        }
        PagedResult results = this.proxy.findAllByCriteria(Form.class, criteria);
        Collection facetNames = results.getFacetNames();
        for (String facetName : facetNames) {
            List topics = results.getTopic(facetName);
            for (FacetTopic topic : topics) {
                TreeNodeImpl treeNode = (TreeNodeImpl)nodes.get(topic.getTopicName());
                if (treeNode == null) continue;
                cartography.put(treeNode, topic.getCount());
            }
        }
        VradiCartographyDTO cartographyDTO = new VradiCartographyDTO(cartography, results.getAll());
        return cartographyDTO;
    }

    public Map<QueryMaker, List<VradiQueryBean>> findQueriesReturningForm(Form form) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findQueriesReturningForm(form)");
        }
        HashMap<QueryMaker, List<VradiQueryBean>> results = new HashMap<QueryMaker, List<VradiQueryBean>>();
        if (form == null) {
            return results;
        }
        List<QueryMaker> queryMakers = this.findQueryMakersWithQueries();
        for (QueryMaker queryMaker : queryMakers) {
            QueryMaker realQueryMaker;
            Set queries = queryMaker.getQueries();
            if (queries == null || queries.isEmpty() || (realQueryMaker = ClientManager.castAsRealQueryMaker((QueryMakerImpl)queryMaker)) == null) continue;
            for (String query : queries) {
                try {
                    VradiQueryBean bean = new VradiQueryBean(query, queryMaker.getWikittyId());
                    String realQuery = bean.getQuery();
                    FilterList filter = VradiQueryParser.parse(realQuery);
                    Search search = Search.query();
                    search.eq("Infogene.id", form.getId());
                    this.buildSearch(filter, search);
                    Criteria criteria = search.criteria();
                    PagedResult forms = this.proxy.findAllByCriteria(Form.class, criteria);
                    if (forms.getNumFound() <= 0) continue;
                    if (results.containsKey(realQueryMaker)) {
                        ((List)results.get(realQueryMaker)).add(bean);
                        continue;
                    }
                    ArrayList<VradiQueryBean> list = new ArrayList<VradiQueryBean>();
                    list.add(bean);
                    results.put(realQueryMaker, list);
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return results;
    }

    public List<QueryMaker> findQueryMakersWithQueries() {
        Criteria criteria = Search.query().bw("QueryMaker.queries", "*", "*").criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(QueryMaker.class, criteria);
        List all = pagedResult.getAll();
        return all;
    }

    Search createSearch(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, List<String>[] thesaurus, String[] statusIds) throws UnsupportedQueryException {
        FilterList filter = VradiQueryParser.parse(query);
        Search search = Search.query();
        this.buildSearch(filter, search);
        if (extension != null) {
            search.eq(Element.ELT_EXTENSION, extension.getName());
        }
        if (dateType != null && beginDate != null && endDate != null) {
            String beginString = WikittyUtil.solrDateFormat.format(beginDate);
            String endString = WikittyUtil.solrDateFormat.format(endDate);
            search.bw(dateType, beginString, endString);
        }
        if (thesaurus != null) {
            for (int i = 0; i < thesaurus.length; ++i) {
                if (thesaurus[i] == null) continue;
                Search subSearch = search.or();
                for (String th : thesaurus[i]) {
                    subSearch.eq("Form.thesaurus", th);
                }
            }
        }
        if (statusIds != null && statusIds.length > 0) {
            Search subSearch = search.or();
            for (String statusId : statusIds) {
                subSearch.eq("Infogene.status", statusId);
            }
        }
        return search;
    }

    void buildSearch(FilterList list, Search search) {
        Search subSearch = null;
        FilterList.Operator operator = list.getOperator();
        if (operator == FilterList.Operator.MUST_PASS_ONE) {
            subSearch = search.or();
        } else if (operator == FilterList.Operator.MUST_PASS_ALL) {
            subSearch = search.and();
        } else if (operator == FilterList.Operator.MUST_NOT_PASS) {
            subSearch = search.not();
        }
        List<Filter> filters = list.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                this.buildSearch((FilterList)filter, subSearch);
                continue;
            }
            if (filter instanceof RangeFilter) {
                this.buildRangeSearch(operator, (RangeFilter)filter, subSearch);
                continue;
            }
            if (!(filter instanceof CompareFilter)) continue;
            this.buildCompareSearch(operator, (CompareFilter)filter, subSearch);
        }
    }

    void buildDescripteurSearch(Search search, String value) {
        Criteria criteria = Search.query().eq("TreeNode.name", value).eq(Element.ELT_EXTENSION, "TreeNode").criteria();
        WikittyService wikittyService = this.proxy.getWikittyService();
        PagedResult queryResult = wikittyService.findAllByCriteria(criteria);
        if (queryResult.getNumFound() > 0) {
            Search subSearch = search.or();
            List result = queryResult.getAll();
            for (Wikitty wikitty : result) {
                subSearch.eq("Form.thesaurus", wikitty.getId());
            }
        }
    }

    void buildRangeSearch(FilterList.Operator operator, RangeFilter rangeFilter, Search search) {
        String name = rangeFilter.getName();
        String lowerValue = rangeFilter.getLowerValue();
        String upperValue = rangeFilter.getUpperValue();
        Search subSearch = search.or();
        if (rangeFilter.match(numericDateFormatPattern)) {
            try {
                Date lowerTime = numericDateFormat.parse(lowerValue);
                lowerTime = DateUtils.setMinTimeOfDay((Date)lowerTime);
                String lowerTimeString = WikittyUtil.solrDateFormat.format(lowerTime);
                Date upperTime = numericDateFormat.parse(upperValue);
                upperTime = DateUtils.setMaxTimeOfDay((Date)upperTime);
                String upperTimeString = WikittyUtil.solrDateFormat.format(upperTime);
                subSearch.bw(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.DATE, lowerTimeString, upperTimeString);
            }
            catch (ParseException e) {
                log.warn((Object)(lowerValue + " OR " + upperValue + " cannot be a date."));
            }
        } else if (rangeFilter.isNumber()) {
            subSearch.bw(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.NUMERIC, lowerValue, upperValue);
        }
        subSearch.bw(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.STRING, lowerValue, upperValue);
    }

    void buildCompareSearch(FilterList.Operator operator, CompareFilter compareFilter, Search search) {
        String name = compareFilter.getName();
        String value = compareFilter.getValue();
        if ("text".equals(name)) {
            search.keyword(value);
            return;
        }
        if (ALIAS_THESAURUS_1.equals(name) || ALIAS_THESAURUS_2.equals(name)) {
            this.buildDescripteurSearch(search, value);
            return;
        }
        if (ALIAS_LAST_MODIFIER.equals(name)) {
            name = "lastModifier";
        } else if (ALIAS_LAST_STATUS_MODIFIER.equals(name)) {
            name = "lastStatusModifier";
        }
        Search subSearch = search.or();
        if (operator == FilterList.Operator.MUST_NOT_PASS) {
            if (compareFilter.match(frenchDateFormatPattern)) {
                try {
                    Date time = frenchDateFormat.parse(value);
                    String timeString = WikittyUtil.solrDateFormat.format(time.getTime());
                    subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.DATE, timeString);
                }
                catch (ParseException e) {
                    log.warn((Object)(value + " cannot be a date."));
                }
            }
        } else if (compareFilter.match(frenchDateFormatPattern)) {
            try {
                Date time = frenchDateFormat.parse(value);
                Date beginDate = DateUtils.setMinTimeOfDay((Date)time);
                Date endDate = DateUtils.setMaxTimeOfDay((Date)time);
                String beginString = WikittyUtil.solrDateFormat.format(beginDate);
                String endString = WikittyUtil.solrDateFormat.format(endDate);
                subSearch.bw(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.DATE, beginString, endString);
            }
            catch (ParseException e) {
                log.warn((Object)(value + " cannot be a date."));
            }
        }
        subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.STRING, value);
        if (!compareFilter.isPhrase()) {
            subSearch.like(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.STRING, value, Like.SearchAs.AsText);
        }
        if (compareFilter.isBoolean()) {
            subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.BOOLEAN, value);
        } else if (compareFilter.isNumber()) {
            subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.NUMERIC, value);
        } else if (compareFilter.match(formIdPattern)) {
            subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.STRING, value);
        } else if (compareFilter.match(uuidPattern)) {
            subSearch.ew(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.STRING, value);
        }
    }
}

