/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateParser2 {
    private static final String ND1 = "N.D.";
    private static final String ND2 = "---";
    private static final TimeZone timezone = TimeZone.getTimeZone("GMT");
    public static final SimpleDateFormat defaultFormat = new SimpleDateFormat("", Locale.FRANCE);
    public static final SimpleDateFormat usFormat = new SimpleDateFormat("", Locale.US);
    public static final String[] frequentMasks = new String[]{"dd MMMM yyyy', \u00e0' HH 'heures'", "dd MMMM yyyy', \u00e0' HH:mm'.'", "dd MMMM yyyy', \u00e0' HH 'h' mm", "yyyy-MM-dd HH:mm:ss"};
    public static final String[] variantMasks = new String[]{"dd MMMM yyyy", "dd MMMM yyyy'.'", "dd/MM/yyyy '\u00e0' HH:mm", "dd/MM/yyyy '\u00e0' HH:mm'.'", "dd/MM/yyyy '\u00e0' HH 'heures'", "dd/MM/yyyy", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "dd MMMM yyyy '\u00e0' HH 'heures'", "dd MMMM yyyy '\u00e0' HH:mm", "dd MMMM yyyy '\u00e0' HH:mm'.'", "dd MMMM yyyy', \u00e0' HH:mm", "dd MMMM yyyy '\u00e0' HH 'h' mm", "dd MMMM yyyy '\u00e0' HH'h'mm", "dd MMMM yyyy', \u00e0' HH'h'mm", "'1.e.r' MMMM yyyy', \u00e0' HH 'heures'", "'1.e.r' MMMM yyyy '\u00e0' HH 'heures'", "'1er' MMMM yyyy', \u00e0' HH 'heures'", "'1er' MMMM yyyy '\u00e0' HH 'heures'"};
    public static final String[] usMasks = new String[]{"E, d MMM yyyy HH:mm:ss Z"};

    private DateParser2() {
    }

    public static Date parse(String source) {
        if (source == null) {
            return null;
        }
        String sourcetrim = source.trim();
        if (sourcetrim.isEmpty() || ND1.equals(sourcetrim) || ND2.equals(sourcetrim)) {
            return null;
        }
        Date date = DateParser2.parse(source, defaultFormat, frequentMasks);
        if (date == null && (date = DateParser2.parse(source, defaultFormat, variantMasks)) == null) {
            date = DateParser2.parse(source, usFormat, usMasks);
        }
        return date;
    }

    public static Date parse(String source, SimpleDateFormat dateFormat, String ... masks) {
        dateFormat.setTimeZone(timezone);
        for (String mask : masks) {
            try {
                dateFormat.applyPattern(mask);
                Date date = dateFormat.parse(source);
                return date;
            }
            catch (ParseException e) {
            }
        }
        return null;
    }
}

