/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;

public class Configuration
extends ApplicationConfig {
    private static final Log log = LogFactory.getLog(Configuration.class);
    protected static Configuration instance = null;

    protected Configuration() {
        for (Option o : Option.values()) {
            if (o.defaultValue == null) continue;
            this.setDefaultOption(o.key, o.defaultValue);
        }
    }

    public static synchronized Configuration getInstance() {
        if (instance == null) {
            try {
                instance = new Configuration();
                instance.parse(new String[0]);
                if (log.isDebugEnabled()) {
                    instance.printConfig();
                }
            }
            catch (Exception e) {
                throw new UnhandledException((Throwable)e);
            }
        }
        return instance;
    }

    public void parse(String[] args) throws ArgumentsParserException {
        super.parse(args);
        this.setSystemDefaultProps();
    }

    @Deprecated
    public File getOptionAsFile2(String key) {
        String optionAsString = this.getOption(key);
        if (optionAsString != null) {
            File optionAsFile = new File(optionAsString);
            return optionAsFile.getAbsoluteFile();
        }
        return null;
    }

    public String getVersion() {
        return this.getOption(Option.APPLICATION_VERSION.key);
    }

    public File getDataDirAsFile() {
        File option = this.getOptionAsFile(Option.DATA_DIR.key);
        return option;
    }

    public File getCommonsPropertiesFile() {
        return this.getOptionAsFile("vradi.data.dir", ".vradi-properties");
    }

    public File getAttachmentsDir() {
        return this.getOptionAsFile("vradi.data.dir", "attachments");
    }

    public File getEmbededFilesDir() {
        return this.getOptionAsFile("vradi.data.dir", "embededFiles");
    }

    public File getQueryHistoryDir() {
        return this.getOptionAsFile("vradi.data.dir", "queryHistory");
    }

    public File getTemplatesDir() {
        return this.getOptionAsFile("vradi.data.dir", "templates");
    }

    public File getPdfDir() {
        return this.getOptionAsFile("vradi.data.dir", "pdf");
    }

    public String getOpenOfficeExecDir() {
        return this.getOption("oOo.exec.folder");
    }

    public String getSmtpHost() {
        return this.getOption("vradi.smtp.host");
    }

    public int getSmtpPort() {
        return this.getOptionAsInt("vradi.smtp.port");
    }

    public String getImapHost() {
        return this.getOption("vradi.imap.host");
    }

    public int getImapPort() {
        return this.getOptionAsInt("vradi.imap.port");
    }

    public String getMailUser() {
        return this.getOption("vradi.mail.user");
    }

    public String getMailFrom() {
        return this.getOption("vradi.mail.from");
    }

    public String getMailFromName() {
        return this.getOption("vradi.mail.fromname");
    }

    public String getMailPassword() {
        return this.getOption("vradi.mail.password");
    }

    public String getOfferMailSubject() {
        String result = this.getOption("vradi.mail.offer.subject");
        return result;
    }

    public boolean isMailDebug() {
        return this.getOptionAsBoolean("vradi.mail.debug");
    }

    public String getSessionDefaultParagraph() {
        return this.getOption("vradi.session.defaultParagraph");
    }

    public boolean skipMigration() {
        return this.getOptionAsBoolean("vradi.migration.skip");
    }

    public Properties getJdbcConfigProperties() {
        File optionAsFile = this.getOptionAsFile2("vradi.jdbc.config.file");
        return this.getFileAsProperties(optionAsFile);
    }

    public Properties getJmsPublisherProperties() {
        File optionAsFile = this.getOptionAsFile2("vradi.jms.publisher.file");
        return this.getFileAsProperties(optionAsFile);
    }

    public URL getJmsPublisherURL() {
        File optionAsFile = this.getOptionAsFile2("vradi.jms.publisher.file");
        try {
            if (optionAsFile != null && optionAsFile.exists() && optionAsFile.isFile()) {
                return optionAsFile.toURI().toURL();
            }
            if (optionAsFile != null) {
                String configFileName = optionAsFile.getName();
                URL url = ClassLoader.getSystemResource(configFileName);
                if (url == null) {
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    url = contextClassLoader.getResource(configFileName);
                }
                return url;
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Properties getJmsSubscriberProperties() {
        File optionAsFile = this.getOptionAsFile2("vradi.jms.subscriber.file");
        return this.getFileAsProperties(optionAsFile);
    }

    protected File getOptionAsFile(String parent, String child) {
        String parentDir = this.getOption(parent);
        File option = new File(parentDir, child);
        return option;
    }

    protected Properties getFileAsProperties(File configFile) {
        Properties properties = new Properties();
        if (configFile != null && configFile.exists() && configFile.isFile()) {
            try {
                URL url = configFile.toURI().toURL();
                InputStream openStream = url.openStream();
                properties.load(openStream);
                openStream.close();
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
                properties = new Properties();
            }
        } else if (configFile != null) {
            String configFileName = configFile.getName();
            URL url = ClassLoader.getSystemResource(configFileName);
            if (url == null) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                url = contextClassLoader.getResource(configFileName);
            }
            if (url != null) {
                try {
                    InputStream openStream = url.openStream();
                    properties.load(openStream);
                    openStream.close();
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                    properties = new Properties();
                }
            }
        }
        return properties;
    }

    protected void setSystemDefaultProps() {
        String[] datadirs;
        for (String datadir : datadirs = new String[]{"solr.data.dir", "vradi.objectStore.dir"}) {
            String value = System.getProperty(datadir, null);
            if (value != null) continue;
            value = this.getOption(datadir);
            log.info((Object)("Setting System property " + datadir + ": " + value));
            System.setProperty(datadir, value);
            this.env.put(datadir, value);
        }
    }

    public static enum Option {
        CONFIG_FILE("config.file", I18n._((String)"vradi.config.configFileName.description"), "vradi-services.properties", String.class, true, true),
        APPLICATION_VERSION("application.version", I18n._((String)"vradi.config.application.version.description"), null, String.class, false, false),
        DATA_DIR("vradi.data.dir", I18n._((String)"vradi.config.data.dir.description"), null, Boolean.class, false, false);

        public final String key;
        public final String description;
        public final String defaultValue;
        public final Class<?> type;
        public final boolean _transient;
        public final boolean _final;

        private Option(String key, String description, String defaultValue, Class<?> type, boolean _transient, boolean _final) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this._final = _final;
            this._transient = _transient;
        }
    }
}

