/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.migration.Migration004;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.VradiStorageServiceImpl;
import com.jurismarches.vradi.services.XmlStreamService;
import com.jurismarches.vradi.services.XmlStreamServiceImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.nuiton.util.Resource;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyService;
import org.sharengo.wikitty.jdbc.WikittyServiceJDBC;

public class ServiceHelper {
    private static final Log log = LogFactory.getLog(ServiceHelper.class);
    public static final String vradiDataDirName = System.getProperty("user.home") + File.separator + ".vradi/vradi-0.0.4";
    private static VradiStorageService vradiStorageService = null;
    private static XmlStreamService xmlStreamService = null;
    private static WikittyProxy wikittyProxy = null;

    public static synchronized VradiStorageService getVradiStorageService() {
        if (vradiStorageService == null) {
            vradiStorageService = new VradiStorageServiceImpl();
        }
        return vradiStorageService;
    }

    public static synchronized XmlStreamService getXmlStreamService() {
        if (xmlStreamService == null) {
            xmlStreamService = new XmlStreamServiceImpl();
        }
        return xmlStreamService;
    }

    public static synchronized WikittyProxy getWikittyProxy() {
        if (wikittyProxy == null) {
            ServiceHelper.checkConfig();
            Logger.getLogger("org.apache.solr").setLevel(Level.WARNING);
            WikittyServiceJDBC wikittyService = new WikittyServiceJDBC(vradiDataDirName);
            wikittyProxy = new WikittyProxy();
            wikittyProxy.setWikittyService((WikittyService)wikittyService);
            Migration004.performMigration();
        }
        return wikittyProxy;
    }

    private static void checkConfig() {
        InputStream inputStream = null;
        FileWriter writer = null;
        try {
            File userSolrConfig;
            log.info((Object)("Using datadir: " + vradiDataDirName));
            File vradiDataDir = new File(vradiDataDirName);
            if (!vradiDataDir.exists()) {
                vradiDataDir.mkdirs();
            }
            if (!(userSolrConfig = new File(vradiDataDirName, "solrconfig.xml")).exists()) {
                log.info((Object)("Setting solr.data.dir: " + vradiDataDirName + "/solr/data"));
                URL url = Resource.getURL((String)"solrconfig.xml");
                inputStream = url.openStream();
                writer = new FileWriter(userSolrConfig);
                SAXBuilder sxb = new SAXBuilder();
                Document document = sxb.build(inputStream);
                Element racine = document.getRootElement();
                racine.getChild("dataDir").setText("${solr.data.dir:" + vradiDataDirName + "/solr/data}");
                XMLOutputter outputter = new XMLOutputter("    ", true);
                outputter.output(document, (Writer)writer);
            }
        }
        catch (Exception e) {
            throw new UnhandledException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(writer);
        }
    }
}

